/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.auditor;

/**
 * Place-holder for the exceptions during audit.
 */
public class AuditorException extends Exception {

    /** Serial number */
    private static final long serialVersionUID = 7156344071455876675L;

    /**
     * Constructs a new <code>AuditorException</code>
     * 
     * @param string
     *            describing the exception.
     * @param e
     *            cause for the exception.
     */
    public AuditorException(String string, Exception e) {
        super(string, e);
    }

    /**
     * Constructs a new <code>AuditorException</code>
     * 
     * @param e
     *            cause for the exception.
     */
    public AuditorException(Exception e) {
        super(e);
    }

    /**
     * Constructs a new <code>AuditorException</code>
     * 
     * @param string
     *            describing the exception.
     */
    public AuditorException(String string) {
        super(string);
    }

}
