/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.auditor;

import org.glite.pseudo.server.PseudoServerComponent;
import org.glite.pseudo.server.auditor.event.AuditEvent;

/**
 * Auditor is a generic audit service use to log AuditEvent.
 * 
 * Imported from org.glite.slcs.auditor.Auditor
 * 
 * @author Valery Tschopp <tschopp@switch.ch>
 */
public interface Auditor extends PseudoServerComponent {

    /**
     * Log the AuditEvent in the underlying audit data store.
     * 
     * @param event
     *            The AuditEvent to log.
     * @throws AuditorException
     *             If an error occurs when storing the AuditEvent
     */
    public void logEvent(AuditEvent event) throws AuditorException;

}
