/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.auditor;

/**
 * <p>
 * Interface for audit event authors.
 * </p>
 */
public interface AuditPersonEntry {

    /**
     * <p>
     * Gets the unique identifier like certificate subject DN for this object.
     * </p>
     * 
     * @return the identifier as String.
     */
    public String getIdentifier();

    /**
     * <p>
     * Gets all the events related to this object.
     * </p>
     * 
     * @return the events in an array.
     */
    public AuditEventEntry[] getAuditEvents();

    /**
     * <p>
     * Adds a new audit event related to this object.
     * </p>
     * 
     * @param event
     *            the event to add
     */
    public void addAuditEvent(AuditEventEntry event);

}
