/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.auditor;

import java.util.Date;

/**
 * <p>
 * Interface for audit events.
 * </p>
 */
public interface AuditEventEntry {

    /**
     * <p>
     * Gets the event type.
     * </p>
     * 
     * @return event type.
     */
    public int getEventType();

    /**
     * <p>
     * Gets the event level.
     * </p>
     * 
     * @return event level.
     */
    public int getEventLevel();

    /**
     * <p>
     * Gets the event date.
     * </p>
     * 
     * @return event date.
     */
    public Date getEventDate();

    /**
     * <p>
     * Gets the event message.
     * </p>
     * 
     * @return event message.
     */
    public String getEventMessage();

    /**
     * <p>
     * Gets the remote address of the event author.
     * </p>
     * 
     * @return remote address.
     */
    public String getRemoteAddress();

    /**
     * <p>
     * Gets the event author.
     * </p>
     * 
     * @return event author.
     */
    public AuditPersonEntry getEventAuthor();
}
