/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.auditor;

import org.glite.pseudo.server.PseudoServerComponent;

/**
 * <p>
 * Interface for pseudonymity service's administrators, i.e. accessing the audit
 * database.
 * </p>
 */
public interface AuditAdmin extends PseudoServerComponent {

    /**
     * <p>
     * Gets person by unique identifier.
     * </p>
     * 
     * @param personId
     *            the identifier.
     * @return the person.
     */
    public AuditPersonEntry getPerson(String personId);

    /**
     * <p>
     * Gets all the persons.
     * </p>
     * 
     * @return the persons.
     */
    public AuditPersonEntry[] getPersons();

    /**
     * <p>
     * Gets event by unique identifier.
     * </p>
     * 
     * @param eventId
     *            the identifier.
     * @return the event.
     */
    public AuditEventEntry getEvent(String eventId);

    /**
     * <p>
     * Gets events by author identifier.
     * </p>
     * 
     * @param personId
     *            author identifier.
     * @return the events.
     */
    public AuditEventEntry[] getEvents(String personId);

    /**
     * <p>
     * Gets events by author identifier.
     * </p>
     * 
     * @param personId
     *            author identifier.
     * @param sortedBy
     *            column used for sorting.
     * @return the events.
     */
    public AuditEventEntry[] getEvents(String personId, String sortedBy);

    /**
     * <p>
     * Gets events by pseudonymous subject DN.
     * </p>
     * 
     * @param pseudoDN
     *            the pseudonymous subject DN.
     * @return the events.
     */
    public AuditEventEntry[] getPseudoEvents(String pseudoDN);

    /**
     * <p>
     * Gets events by pseudonymous subject DN.
     * </p>
     * 
     * @param pseudoDN
     *            the pseudonymous subject DN.
     * @param sortedBy
     *            column used for sorting.
     * @return the events.
     */
    public AuditEventEntry[] getPseudoEvents(String pseudoDN, String sortedBy);
}
