/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.attribute;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.glite.pseudo.server.PseudoServerComponent;

/**
 * Helper class for the attribute definitions as defined by the XML file
 * attribute-defs.xml.
 * 
 * Imported from org.glite.slcs.attribute.AttributeDefinitions
 * 
 * @author Valery Tschopp &lt;tschopp@switch.ch&gt;
 */
public interface AttributeDefinitions extends PseudoServerComponent {

    /**
     * Creates an {@link Attribute} with the given name and value. The attribute
     * properties <code>required</code>, <code>displayName</code> and
     * <code>caseSensitive</code> are set as defined by the attribute
     * definitions.
     * 
     * @param name
     *            The attribute name.
     * @param value
     *            The attribute value.
     * @return The new attribute with all properties set.
     */
    public Attribute createAttribute(String name, String value);

    /**
     * Return the list of user's {@link Attribute}s, as defined in the attribute
     * definitions, from the HTTP request.
     * 
     * @param request
     *            The HttpServletRequest object
     * @return The list of user's attributes
     */
    public List<Attribute> getUserAttributes(HttpServletRequest request);

    /**
     * @return The list of {@link AttributeDefinition}
     */
    public List<AttributeDefinition> getAttributeDefinitions();

    /**
     * Gets the display name, as defined by the {@link AttributeDefinition}s,
     * for the given attribute. If the display name is not defined, the
     * attribute name is returned.
     * 
     * @param attribute
     *            The attribute.
     * @return The display name for this attribute
     */
    public String getAttributeDisplayName(Attribute attribute);

    /**
     * Sets the display name, as defined in the {@link AttributeDefinition}s,
     * for all attributes in the list.
     * 
     * @param attributes
     *            The list of attributes to set display name.
     */
    public void setDisplayNames(List<Attribute> attributes);

    /**
     * Returns a list of attribute names defined as required.
     * 
     * @return the list of required attribute name
     */
    public List<String> getRequiredAttributeNames();

}
