/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.attribute;

/**
 * Place-holder for the exceptions related to attribute definitions.
 */
public class AttributeDefinitionException extends Exception {

    /** Serial number */
    private static final long serialVersionUID = -8912337376466525543L;

    /**
     * Constructs a new <code>AttributeDefinitionException</code>
     */
    public AttributeDefinitionException() {
        super();
    }

    /**
     * Constructs a new <code>AttributeDefinitionException</code>
     * 
     * @param string
     *            describing the exception.
     * @param e
     *            cause for the exception.
     */
    public AttributeDefinitionException(String string, Exception e) {
        super(string, e);
    }

    /**
     * Constructs a new <code>AttributeDefinitionException</code>
     * 
     * @param e
     *            cause for the exception.
     */
    public AttributeDefinitionException(Exception e) {
        super(e);
    }

    /**
     * Constructs a new <code>AttributeDefinitionException</code>
     * 
     * @param string
     *            describing the exception.
     */
    public AttributeDefinitionException(String string) {
        super(string);
    }

}
