/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.attribute;

import java.util.Comparator;

/**
 * Comparator to sort a list of AttributeDefinition. The displayName (human
 * readable) is used as sorting key.
 * 
 * Imported from org.glite.slcs.attribute.AttributeDefinitionComparator
 * 
 * @see Collections#sort(java.util.List, Comparator)
 * 
 * @author Valery Tschopp &lt;tschopp@switch.ch&gt;
 */
public class AttributeDefinitionComparator implements
        Comparator<AttributeDefinition> {

    /**
     * Compare two AttributeDefinition Display name
     */
    public int compare(AttributeDefinition attribute1,
            AttributeDefinition attribute2) {
        if (attribute1 == attribute2) {
            return 0;
        }
        String displayName1 = attribute1.getDisplayName();
        String displayName2 = attribute2.getDisplayName();
        return displayName1.compareTo(displayName2);
    }
}