/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.acl;

import java.util.List;

import javax.servlet.FilterConfig;

import org.glite.pseudo.server.PseudoServerComponent;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.attribute.Attribute;

/**
 * 
 * AccessControlList is an interface for ACL based on attributes.
 * 
 * @author Valery Tschopp <tschopp@switch.ch>
 * 
 *         Imported from org.glite.slcs.acl.AccessControlList.
 */
public interface AccessControlList extends PseudoServerComponent {

    /**
     * Grant access to user based on his attributes.
     * 
     * @param attributes
     *            List of user's {@link Attribute}s
     * @return <code>true</code> if the user is authorized
     */
    public boolean isAuthorized(List<Attribute> attributes);

    /**
     * Shutdowns the additional resources.
     */
    public void shutdown();

}
