/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.aaclient;

/**
 * Placeholder for the exceptions during the communication between the
 * pseudonymity service and attribute authority.
 */
public class AAClientException extends Exception {

    /** Serial number */
    private static final long serialVersionUID = 4250953752954227489L;

    /**
     * Constructs a new <code>AAClientEception</code>.
     */
    public AAClientException() {
        super();
    }

    /**
     * Constructs a new <code>AAClientEception</code>.
     * 
     * @param string
     *            describing the exception
     * @param e
     *            cause for the exception
     */
    public AAClientException(String string, Exception e) {
        super(string, e);
    }

    /**
     * Constructs a new <code>AAClientEception</code>.
     * 
     * @param e
     *            cause for the exception
     */
    public AAClientException(Exception e) {
        super(e);
    }

    /**
     * Constructs a new <code>AAClientEception</code>.
     * 
     * @param string
     *            describing the exception
     */
    public AAClientException(String string) {
        super(string);
    }

}
