/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server.aaclient;

import java.security.cert.X509Certificate;

import org.glite.pseudo.server.PseudoServerComponent;

/**
 * <p>
 * Interface AAClient defines the operations needed for a generic Attribute
 * Authority (e.g. VOMS) client.
 * </p>
 */
public interface AAClient extends PseudoServerComponent {

    /**
     * <p>
     * Registers a new certificate as an alias to the original to the Attribute
     * Authority.
     * </p>
     * 
     * @param original
     *            Original certificate
     * @param alias
     *            New (alias) certificate
     * @throws AAClientException
     *             if something goes wrong
     */
    public void registerCertificate(X509Certificate original,
            X509Certificate alias) throws AAClientException;

}
