/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server;

/**
 * <p>
 * Common exception class for the server exceptions.
 * </p>
 */
public class PseudoServerException extends Exception {

    /** The serial number */
    private static final long serialVersionUID = 2767774490991448176L;

    /**
     * Constructs a new <code>PseudoServerException</code>
     */
    public PseudoServerException() {
        super();
    }

    /**
     * Constructs a new <code>PseudoServerException</code>
     * 
     * @param string
     *            describing the exception.
     * @param e
     *            cause for the exception.
     */
    public PseudoServerException(String string, Exception e) {
        super(string, e);
    }

    /**
     * Constructs a new <code>PseudoServerException</code>
     * 
     * @param e
     *            cause for the exception.
     */
    public PseudoServerException(Exception e) {
        super(e);
    }

    /**
     * Constructs a new <code>PseudoServerException</code>
     * 
     * @param string
     *            describing the exception.
     */
    public PseudoServerException(String string) {
        super(string);
    }

    /**
     * Constructs a new <code>PseudoServerException</code>
     * 
     * @param ex
     *            describing the exception.
     */
    public PseudoServerException(Throwable ex) {
        super(ex);
    }
}
