/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server;

import org.glite.pseudo.server.config.PseudoServerConfiguration;

/**
 * <code>PseudoServerComponent</code> is an interface that all the Pseudonymity
 * Server's components must implement.
 * 
 * @author Henri Mikkonen &lt;henri.mikkonen@hip.fi&gt;
 */
public interface PseudoServerComponent {

    /**
     * Verifies the configuration for the component and initializes the
     * necessary resources.
     * 
     * @param configuration
     *            The configuration for the Pseudonymity Server
     * @throws PseudoServerException
     *             If the initialization of the component fails
     */
    public void init(PseudoServerConfiguration configuration)
            throws PseudoServerException;

    /**
     * Shuts down all the resources allocated for the component.
     */
    public void shutdown();

}
