/**
 * Copyright (c) Members of the EMI Collaboration. 2011.
 * See http://eu-emi.eu/partners/ for details on the copyright holders.
 * For license conditions see http://www.apache.org/licenses/LICENSE-2.0
 */
package org.glite.pseudo.server;

/**
 * <p>
 * Some constant variables used by pseudonymity service.
 * </p>
 * 
 * @author Henri Mikkonen &lt;henri.mikkonen@hip.fi&gt;
 */
public class Constants {

    public static final String CONFIGURATION_CERTIFICATE_POLICY_ID = "CertificatePolicy";

    /**
     * The identifier for the SLCSSession attribute containing the user proxy
     * certificate's subject DN
     */
    public static final String USER_SUBJECT_DN_ATTR_IDENTIFIER = "UserSubjectDN";

    /**
     * The identifier for the SLCSSession attribute containing the remote IP
     * address
     */
    public static final String USER_REMOTE_ADDRESS_ATTR_IDENTIFIER = "RemoteAddress";

    /** The identifier for the administrator session object */
    public static final String ADMIN_USER_SESSION_ID = "PseudoServiceAdmin";

    /** The audit level for the admin user login */
    public static final int AUDIT_LEVEL_ADMIN_LOGIN = 100;

    /** The audit level for the admin listing events for a specific user */
    public static final int AUDIT_LEVEL_ADMIN_LIST_EVENTS = 101;

    /**
     * The audit level for the admin revealing all the details for a specific
     * event
     */
    public static final int AUDIT_LEVEL_ADMIN_EVENT_DETAILS = 102;

    /** The audit level for the pseudonymous DN issuance */
    public static final int AUDIT_LEVEL_PSEUDO_DN_ISSUANCE = 201;

    /** The audit level for certificate requests */
    public static final int AUDIT_LEVEL_CERTIFICATE_REQUEST = 301;

    /** The audit level for the certificate issuance. */
    public static final int AUDIT_LEVEL_CERTIFICATE_ISSUANCE = 302;

    /**
     * The audit level for the certificate registration to the Attribute
     * authority
     */
    public static final int AUDIT_LEVEL_CERTIFICATE_REGISTRATION = 303;

    /** The audit level for the system-related events. */
    public static final int AUDIT_LEVEL_SYSTEM = 900;

}
