/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathMod
extends Task {
    private String target;
    private String prefix;
    private String componentName;
    private String specialSeq;
    private Boolean verbose;
    private HashMap<String, String> ldirs;
    private String dirs;
    private String noMapTag;

    public void execute() throws BuildException {
        if (this.prefix == null) {
            throw new BuildException("attribute prefix must be specified");
        }
        if (this.target == null) {
            throw new BuildException("attribute target must be specified");
        }
        if (this.dirs == null) {
            throw new BuildException("attribute dirs must be specified");
        }
        if (this.specialSeq == null) {
            this.specialSeq = "__c";
        }
        if (this.noMapTag == null) {
            this.noMapTag = "noMap";
        }
        if (this.verbose == null) {
            this.verbose = false;
        }
        String[] ddir = this.dirs.split(",");
        this.ldirs = new HashMap();
        if (this.verbose.booleanValue()) {
            this.log("use special string: " + this.specialSeq);
            this.log("dirMapper:");
        }
        if (ddir.length > 0) {
            String[] stringArray = ddir;
            int n = ddir.length;
            int n2 = 0;
            while (n2 < n) {
                String map = stringArray[n2];
                String[] tdir = map.split("::");
                if (tdir.length == 2) {
                    if (this.componentName != null) {
                        tdir[1] = tdir[1].replace(this.specialSeq, this.componentName);
                    }
                    this.ldirs.put(tdir[0], tdir[1]);
                    if (this.verbose.booleanValue()) {
                        this.log(String.valueOf(tdir[0]) + " --> " + tdir[1]);
                    }
                } else {
                    throw new BuildException("error in parse attribute dirs");
                }
                ++n2;
            }
        }
        Project p = this.getProject();
        Hashtable properties = p.getProperties();
        Set keySet = properties.keySet();
        for (String propName : keySet) {
            if (propName.startsWith(this.prefix)) {
                this.processPropertyEntry(false, propName, p, properties);
                continue;
            }
            if (!propName.startsWith(String.valueOf(this.noMapTag) + "." + this.prefix)) continue;
            this.processPropertyEntry(true, propName, p, properties);
        }
    }

    private void processPropertyEntry(boolean noMap, String propName, Project p, Hashtable<String, String> properties) {
        CallTarget cl = (CallTarget)p.createTask("antcall");
        cl.setOwningTarget(this.getOwningTarget());
        cl.init();
        cl.setInheritAll(true);
        cl.setTarget(this.target);
        Property param1 = cl.createParam();
        param1.setName("file");
        param1.setValue(properties.get(propName));
        Property param2 = cl.createParam();
        param2.setName("todir");
        String fullPrefix = noMap ? String.valueOf(this.noMapTag) + "." + this.prefix : this.prefix;
        propName = propName.replace(String.valueOf(fullPrefix) + ".", "");
        int pos = propName.lastIndexOf(".");
        String num = propName.substring(pos + 1);
        try {
            Integer.parseInt(num);
        }
        catch (Exception e) {
            throw new BuildException("property with prefix=" + fullPrefix + " must be end with .number");
        }
        propName = propName.substring(0, pos);
        propName = this.property2path(propName, properties);
        if (!noMap) {
            for (String from : this.ldirs.keySet()) {
                String to = this.ldirs.get(from);
                if (!propName.contains(from)) continue;
                propName = propName.replace(from, to);
            }
        }
        param2.setValue(propName);
        cl.execute();
    }

    protected String property2path(String propName, Hashtable<String, String> properties) {
        char[] chars = propName.toCharArray();
        StringBuilder ret = new StringBuilder();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '$' && i + 3 < chars.length && chars[i + 1] == '{') {
                int j = i + 2;
                StringBuilder varName = new StringBuilder();
                while (j < chars.length) {
                    if (chars[j] == '}') break;
                    varName.append(chars[j]);
                    ++j;
                }
                if (j == chars.length) {
                    ret.append(chars[i]);
                    if (this.verbose.booleanValue()) {
                        this.log("Found '${' string without closing '}', ignoring");
                    }
                } else {
                    String varNameS = varName.toString();
                    if (properties.containsKey(varNameS)) {
                        ret.append(properties.get(varNameS));
                        i = j;
                    } else {
                        ret.append(chars[i]);
                        if (this.verbose.booleanValue()) {
                            this.log("Found variable reference " + varNameS + " but is not defined, ignoring");
                        }
                    }
                }
            } else if (chars[i] == '\\' && i + 1 < chars.length && chars[i + 1] == '.') {
                ret.append('.');
                ++i;
            } else if (chars[i] == '.') {
                ret.append(File.separator);
            } else {
                ret.append(chars[i]);
            }
            ++i;
        }
        return ret.toString();
    }

    public void setNoMapTag(String tag) {
        this.noMapTag = tag;
    }

    public void setTarget(String tar) {
        this.target = tar;
    }

    public void setPrefix(String pref) {
        this.prefix = pref;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setDirs(String dirs) {
        this.dirs = dirs;
    }

    public void setSpecialSeq(String specialSeq) {
        this.specialSeq = specialSeq;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }
}

