package org.glite.pseudo.common.pki;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CertificateTest {
	
	/** Logging */
	private static Logger log = LoggerFactory.getLogger(CertificateTest.class);
	
	private static final String TEST_CERTIFICATE_FILE = "src/test/resources/test-cert.pem";
	
	@Test
	public void initializeByFile() {
		Certificate certificate = null;
		try {
			certificate = Certificate.readPEM(new FileReader(TEST_CERTIFICATE_FILE));
		} catch (FileNotFoundException e) {
			log.error("Could not find the file " + TEST_CERTIFICATE_FILE, e);
		} catch (IOException e) {
			log.error("Error while reading the file " + TEST_CERTIFICATE_FILE, e);
		} catch (GeneralSecurityException e) {
			log.error("Security error while constructing the certificate", e);
		}
		X509Certificate x509 = certificate.getCertificate();
		Assert.assertEquals("C=EU,ST=Schengen,L=City,O=Organization,CN=test-certificate", x509.getSubjectDN().toString());
		
		FileReader reader = null;
		try {
			reader = new FileReader(TEST_CERTIFICATE_FILE);
		} catch (FileNotFoundException e) {
			log.error("Could not find the file " + TEST_CERTIFICATE_FILE, e);
		}
		String fileContents = "";
		try {
			int content = reader.read();
			while (content != -1) {
				fileContents = fileContents + (char) content;
				content = reader.read();
			}
		} catch (IOException e) {
			log.error("Could not read the file " + TEST_CERTIFICATE_FILE, e);
		}
		
		String certContents = null;
		try {
			certContents = certificate.getPEM();
		} catch (IOException e) {
			log.error("Could not encode the certificate to PEM", e);
		}
		
		// for some reason the test below fails even though the string are
		// similar.
		//Assert.assertEquals(certContents.trim(), fileContents.trim());

	}
}
