package org.glite.pseudo.common.pki;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CertificateRequestTest {
	
	/** Logging */
	private static Logger log = LoggerFactory.getLogger(CertificateRequestTest.class);
	
	private static final String TEST_CERTIFICATE_REQUEST_FILE = "src/test/resources/test-req.pem";
	
	@Test
	public void initializeByFile() {
		CertificateRequest certReq = null;
		try {
			certReq = CertificateRequest.readPEM(new FileReader(TEST_CERTIFICATE_REQUEST_FILE));
		} catch (FileNotFoundException e) {
			log.error("Could not find the file " + TEST_CERTIFICATE_REQUEST_FILE, e);
		} catch (IOException e) {
			log.error("Error while reading the file " + TEST_CERTIFICATE_REQUEST_FILE, e);
		} catch (GeneralSecurityException e) {
			log.error("Security error while constructing the certificate request", e);
		}
		Assert.assertEquals("C=EU,ST=Schengen,L=City,O=Organization,CN=test-certificate-request", certReq.getPrincipal().toString());

		FileReader reader = null;
		try {
			reader = new FileReader(TEST_CERTIFICATE_REQUEST_FILE);
		} catch (FileNotFoundException e) {
			log.error("Could not find the file " + TEST_CERTIFICATE_REQUEST_FILE, e);
		}
		String fileContents = "";
		try {
			int content = reader.read();
			while (content != -1) {
				fileContents = fileContents + (char) content;
				content = reader.read();
			}
		} catch (IOException e) {
			log.error("Could not read the file " + TEST_CERTIFICATE_REQUEST_FILE, e);
		}
		
		String certContents = certReq.getPEMEncoded();
		
		Assert.assertEquals(certContents, fileContents);
	}
	
	@Test
	public void constructNew() {
		CertificateKeys certKeys = null;
		try {
			certKeys = new CertificateKeys(2048, "abc123".toCharArray());
		} catch (GeneralSecurityException e) {
			log.error("Security error while generating a new keypair", e);
		}
		CertificateRequest certReq = null;
		try {
			certReq = new CertificateRequest(certKeys, "C=EU,ST=Schengen,L=City,O=Organization,CN=test-certificate-request");
		} catch (GeneralSecurityException e) {
			log.error("Security error while constructing the certificate request", e);
		}
		Assert.assertEquals("C=EU,ST=Schengen,L=City,O=Organization,CN=test-certificate-request", certReq.getPrincipal().toString());
	}
}
