package org.glite.pseudo.common.log;

import java.io.FileInputStream;
import java.io.FileNotFoundException;

import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;

/**
 * This class is used for loading the logback configuration file. 
 */
public class LogbackLoggingService {

    /**
     * Constructs a new <code>LogbackLoggingService</code>.
     * @param loggingConfigurationFile logback configuration file
     */
    public LogbackLoggingService(String loggingConfigurationFile) {
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
        StatusManager statusManager = loggerContext.getStatusManager();
        statusManager.add(new InfoStatus("Loading logging configuration file: " + loggingConfigurationFile, this));
        loggerContext.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(loggerContext);
        try {
			configurator.doConfigure(new FileInputStream(loggingConfigurationFile));
		} catch (FileNotFoundException e) {
			statusManager.add(new ErrorStatus("Error loading logging configuration file: " + loggingConfigurationFile, this, e));
		} catch (JoranException e) {
			statusManager.add(new ErrorStatus("Error loading logging configuration file: " + loggingConfigurationFile, this, e));
		}
        loggerContext.start();
    }

}
