Buildroot: %{_builddir}/%{name}-root
Name: emi-emir
Version: 1.2.1
Release: 0.sl5
Summary: EMIR Server
License: ASL 2.0
Distribution: SL5
Group: Applications/Internet
URL: https://github.com/eu-emi/emiregistry
Requires: java-1.6.0-openjdk, mongo-10gen, mongo-10gen-server

BuildArch: noarch
Packager: EMI emir@niif.hu
BuildRequires: subversion  
BuildRequires: maven  
BuildRequires: java-1.6.0-openjdk-devel 
Source0 : emi-emir-1.2.1-0.src.tar.gz

%description
A Service Registry conceived during the EMI project. 
Its main goals to discover all the Service endpoints that 
exist and hence obtain future information about them. The key 
part to the service registry is the management procedures and 
policies which it implements. These are dictated by the stakeholders 
of the various infrastructures and have been implemented in the registry.

This package contains the EMIR server.

%changelog
* Wed Feb 29 2012 Gabor Szigeti <szigeti@niif.hu>
- Fixing mongodb dependency, resource bugs

* Wed Nov 30 2011 Ivan Marton <martoni@niif.hu>
- Fixing paths, init scripts, related directories
- creating proper user and group
- eliminating UNICORE heritage

* Fri Nov 02 2011 Shiraz Memon <emir@niif.hu> 
- Initial rpm package

%prep 
%setup -q -c . 
%build
%install 
rm -rf $RPM_BUILD_ROOT 
mkdir -p $RPM_BUILD_ROOT 
cd emir-dist 
mvn -q package -Ppackman -Dmaven.test.skip -Dmaven.repo.local=`pwd`/maven-repo -Dpackage.version=1.2.1 -Dpackage.release=0 -Ddistribution=SL5 -Dpackage.config.dir=src/main/package -Dpackage.type=prep.src.rpm -DindexJars -B; 
cp -r target/SL5/RPMS/builddir/* $RPM_BUILD_ROOT 
%clean 
rm -rf $RPM_BUILD_ROOT


%files
%defattr(755, emi, emi, -)
#
# Config files
#
%dir %attr(755 emi emi) "/etc/emi/emir"
%dir %attr(755 emi emi) "/etc/emi/emir/users"
%dir %attr(755 emi emi) "/etc/emi/emir/xacml2Policies"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/startup.properties"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/log4j.properties"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/users/testUdb-strict.xml"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/users/testUdb-regexp.xml"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/xacml2Policies/01coreResources.xml"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/xacml2Policies/99finalDeny.xml"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/emir.config"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/emir.acl"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/inputfilters"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/outputfilters"
%config(noreplace) %attr(0644 emi emi) "/etc/emi/emir/xacml2.config"
%attr(0755 emi emi) "/etc/rc.d/init.d/emi-emir"


%attr(0755 - -) "/usr/sbin/emir-start.sh"
%attr(0755 - -) "/usr/sbin/emir-stop.sh"
%attr(0755 - -) "/usr/sbin/emir-status.sh"
#
# Documentation
#
%docdir %attr(755 root root) "/usr/share/doc/emi/emir/"
"/usr/share/doc/emi/emir/*"

#
# jar files
#
%attr(755 root root) %dir "/usr/share/emi/emir/lib"
%attr(644 root root) "/usr/share/emi/emir/lib/*.jar"

#
# logs
#
%dir %attr(0755 emi emi) "/var/log/emi/emir"
%dir %attr(0755 emi emi) "/var/run/emi"
%dir %attr(0755 emi emi) "/var/run/emi/emir"
%dir %attr(0755 emi emi) "/var/lib/emi"
%dir %attr(0755 emi emi) "/var/lib/emi/emir"
%dir %attr(0755 emi emi) "/var/lib/emi/emir/data"

#
# dealing with .gitignores
#
# %attr(0700 emi emi) "/var/lib/emi/emir/data/.gitignore"
# %attr(0700 emi emi) "/var/log/emi/emir/.gitignore"
# %attr(0700 emi emi) "/var/run/emi/emir/.gitignore"
# %attr(0700 emi emi) "/usr/share/doc/emi/emir/.gitignore"

#
# dir %attr(0700 emi emi) "/var/lib/emir"
#

%pre
if [ -e /etc/init.d/emi-emir ]; then
  /etc/init.d/emi-emir stop
fi
/usr/sbin/groupadd -r emi 2>/dev/null || :
/usr/sbin/useradd -c "EMI" -g emi \
    -s /sbin/nologin -r -d /usr/share/emi emi 2>/dev/null || :
	
%post
if [ -e /sbin/chkconfig ]; then
    /sbin/chkconfig --add emi-emir
elif [ -e /sbin/insserv ]; then
    /sbin/insserv emi-emir
fi


%preun
if [ -e /sbin/chkconfig ]; then
  if [ "$1" = "0" ]; then 
      /etc/init.d/emi-emir stop >/dev/null 2>&1
      /sbin/chkconfig --del emi-emir
  fi
elif [ -e /sbin/insserv ]; then
  if [ "$1" = "0" ]; then 
      /etc/init.d/emi-emir stop >/dev/null 2>&1
      /sbin/insserv -r emi-emir
  fi
fi
