/*
 * Copyright (c) Members of the EGEE Collaboration. 2006-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright holders.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.glite.authz.pep.obligation.eesmap;

import org.glite.authz.pep.obligation.ObligationProcessingException;

/**
 * Exception for the EESObligationHandler
 */
public class EESObligationHandlerException extends
        ObligationProcessingException {

    /** Serial version */
    private static final long serialVersionUID= 764769009541024847L;

    /**
     * Default constructor
     */
    public EESObligationHandlerException() {
        super();
    }

    /**
     * @param message
     */
    public EESObligationHandlerException(String message) {
        super(message);
    }

    /**
     * @param wrappedException
     */
    public EESObligationHandlerException(Exception wrappedException) {
        super(wrappedException);
    }

    /**
     * @param message
     * @param wrappedException
     */
    public EESObligationHandlerException(String message,
            Exception wrappedException) {
        super(message, wrappedException);
    }

}
