/*
 * Copyright (c) Members of the EGEE Collaboration. 2006-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright holders.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.glite.authz.pep.obligation.eesmap;

import org.glite.authz.common.config.AbstractConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.glite.authz.common.config.IniSectionConfigurationParser;
import org.glite.authz.pep.obligation.ObligationHandler;

import org.ini4j.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * EESObligationHandlerConfigurationParser ini configuration parser for the
 * {@link EESObligationHandler}.
 */
public class EESObligationHandlerConfigurationParser implements
        IniSectionConfigurationParser<ObligationHandler> {

    /**
     * The name of the {@value} property which give the entityID of the
     * obligation handler
     */
    public static final String ENTITY_ID_PROP= "entityId";

    /**
     * The name of the {@value} property which gives ID of the obligation
     * handled by this obligation handler
     */
    public static final String HANDLED_OBLIGATION_ID_PROP= "handledObligationId";

    /**
     * The name of the {@value} property which gives the absolute path to the
     * mapping file that maps subjects to groups.
     */
    public static final String EES_ENDPOINT_PROP= "eesEndpoint";

    /** Class logger. */
    private final Logger log= LoggerFactory.getLogger(EESObligationHandlerConfigurationParser.class);

    /**
     * TODO documentation
     */
    public ObligationHandler parse(Ini.Section iniConfig,
            AbstractConfigurationBuilder<?> configBuilder)
            throws ConfigurationException {

        // section name
        String name= iniConfig.getName();

        // get entityID from ini
        String entityId= IniConfigUtil.getString(iniConfig, ENTITY_ID_PROP);
        log.info("{}: entityId: {}", name, entityId);

        // get handled obgliation ID
        String obligationId= IniConfigUtil.getString(iniConfig,
                                                     HANDLED_OBLIGATION_ID_PROP);
        log.info("{}: handled obligationID: {}", name, obligationId);

        // get EES endpoint URL
        String endPoint= IniConfigUtil.getString(iniConfig, EES_ENDPOINT_PROP);
        log.info("{}: EES endpoint: {}", name, endPoint);

        EESObligationHandler oh= new EESObligationHandler(name,
                                                          obligationId,
                                                          endPoint);
        oh.setEntityId(entityId);

        return oh;
    }
}
