/**********************************************************************

gss_mech_choose.c

Description:
	Untill the mech_glue is working, this routine
	can be used inplace of the gssapi lib. It will
	look for the ENV variable of GSS_LIB_PATH 
	to give the path to the gssapi shared lib to dynamicly load

CVS Information:

    $Source: $
    $Date: $
    $Revision:$
    $Author: $

**********************************************************************/

static char *rcsid = "$Header: $";

/**********************************************************************
                             Include header files
**********************************************************************/
#include <stdio.h>
#include <string.h>
#ifdef WIN32
#include <windows.h>
#else
#define MessageBox(A,B,C,D) fprintf(stderr,"%s\n", B)
#include <dlfcn.h>
#endif

#include <gssapi.h>

#define COM_CODE(name) static OM_uint32 ms;\
    static OM_uint32 (GSS_CALLCONV *function)() = NULL; \
	if (!function) function_init(name, &function);
	
#define GSS_LIB_FILE_NAME "/etc/grid-security/gss-lib"

/**********************************************************************
                               Type definitions
**********************************************************************/

/**********************************************************************
                          Module specific prototypes
**********************************************************************/

static void
function_init(char * name, OM_uint32 (GSS_CALLCONV **pfunction)());

static OM_uint32 GSS_CALLCONV
function_error();



/**********************************************************************
                       Define module specific variables
**********************************************************************/
/* we define the oid values here which are required */

static gss_OID_desc  GSS_C_NT_USER_NAME_desc = 
		{10, (void *)"\x2a\x86\x48\x86\xf7\x12\x01\x02\x01\x01"};
gss_OID GSS_C_NT_USER_NAME = &GSS_C_NT_USER_NAME_desc;

static gss_OID_desc   GSS_C_NT_MACHINE_UID_NAME_desc = 
		{10, (void *)"\x2a\x86\x48\x86\xf7\x12\x01\x02\x01\x02"};
gss_OID GSS_C_NT_MACHINE_UID_NAME = &GSS_C_NT_MACHINE_UID_NAME_desc;

static gss_OID_desc  GSS_C_NT_STRING_UID_NAME_desc = 
		{10, (void *)"\x2a\x86\x48\x86\xf7\x12\x01\x02\x01\x03"};
gss_OID GSS_C_NT_STRING_UID_NAME = &GSS_C_NT_STRING_UID_NAME_desc;

static gss_OID_desc  GSS_C_NT_HOSTBASED_SERVICE_X_desc = 
		{6, (void *)"\x2b\x06\x01\x05\x06\x02"};
gss_OID GSS_C_NT_HOSTBASED_SERVICE_X = &GSS_C_NT_HOSTBASED_SERVICE_X_desc;

static gss_OID_desc  GSS_C_NT_HOSTBASED_SERVICE_desc = 
		{10, (void *)"\x2a\x86\x48\x86\xf7\x12\x01\x02\x01\x04"};
gss_OID GSS_C_NT_HOSTBASED_SERVICE = &GSS_C_NT_HOSTBASED_SERVICE_desc;

static gss_OID_desc  GSS_C_NT_ANONYMOUS_desc = 
		{6, (void *)"\x2b\x06\01\x05\x06\x03"};
gss_OID GSS_C_NT_ANONYMOUS = &GSS_C_NT_ANONYMOUS_desc;

static gss_OID_desc  GSS_C_NT_EXPORT_NAME_desc = 
		{6, (void *)"\x2b\x06\x01\x05\x06\x04"};
gss_OID GSS_C_NT_EXPORT_NAME = &GSS_C_NT_EXPORT_NAME_desc;


static const gss_OID_desc GSS_DISALLOW_ENCRYPTION_OID =
   {11, "\x2b\x06\x01\x04\x01\x9b\x50\x01\x01\x03\x01"}; 
const gss_OID_desc * const GSS_DISALLOW_ENCRYPTION =
   &GSS_DISALLOW_ENCRYPTION_OID;

static const gss_OID_desc GSS_PROTECTION_FAIL_ON_CONTEXT_EXPIRATION_OID =
   {11, "\x2b\x06\x01\x04\x01\x9b\x50\x01\x01\x03\x02"}; 
const gss_OID_desc * const GSS_PROTECTION_FAIL_ON_CONTEXT_EXPIRATION =
   &GSS_PROTECTION_FAIL_ON_CONTEXT_EXPIRATION_OID;

static const gss_OID_desc GSS_APPLICATION_WILL_HANDLE_EXTENSIONS_OID =
   {11, "\x2b\x06\x01\x04\x01\x9b\x50\x01\x01\x03\x03"}; 

const gss_OID_desc * const GSS_APPLICATION_WILL_HANDLE_EXTENSIONS =
   &GSS_APPLICATION_WILL_HANDLE_EXTENSIONS_OID;


/*
 * for backwards compatability, also define the V1 constant OID
 * pointing the V2 OIDs. This is done mostly for DLL compatability
 */

gss_OID gss_nt_user_name =        &GSS_C_NT_USER_NAME_desc;
gss_OID gss_nt_machine_uid_name = &GSS_C_NT_MACHINE_UID_NAME_desc;
gss_OID gss_nt_string_uid_name =  &GSS_C_NT_STRING_UID_NAME_desc;
gss_OID gss_nt_service_name = 	  &GSS_C_NT_HOSTBASED_SERVICE_desc;

/* new between 2.0 and 2.2.4 */

static const gss_OID_desc gss_mech_oid_globus_gssapi_openssl = 
    {9, "\x2b\x06\x01\x04\x01\x9b\x50\x01\x01"};

const gss_OID_desc * const gss_mech_globus_gssapi_openssl = 
        &gss_mech_oid_globus_gssapi_openssl;

static const gss_OID_desc gss_proxycertinfo_extension_oid =
     {11, "\x2b\x06\x01\x04\x01\x9b\x50\x01\x01\x01\x06"}; 
const gss_OID_desc * const gss_proxycertinfo_extension = 
                &gss_proxycertinfo_extension_oid;

#ifdef GLOBUS_GSI_GSSAPI_MODULE
/* The Globus activation requires a static structure, which must be
 * present at load time. We are trying to dynamicly load the GSSAPIs
 * so this presents a problem. We need to define a structure here,
 * and hanlde the situation when the activate or deactivate is called.
 * If it is called we will do our g_initialize then see if
 * an activation structure was loaded, and if so call its activation.
 * This is not very generic, so we will do the best we can. 
 */

static int mechglue_activate(void);
static int mechglue_deactivate(void);
static globus_version_t local_version={1,1,1044398536,28};

globus_module_descriptor_t globus_i_gsi_gssapi_module = 
{
      "mechglue",
      mechglue_activate,
      mechglue_deactivate,
      GLOBUS_NULL,
      GLOBUS_NULL,
      &local_version
};
#endif


/* handle of the real gssapi32.dll */
#ifdef WIN32
HMODULE gssapi_handle = NULL;
#else
void * gssapi_handle = NULL;
#endif

/**********************************************************************
**********************************************************************/
static OM_uint32 GSS_CALLCONV
function_error()
{
#ifdef WIN32
    MessageBox(0,"Entry not in the gssapi","GSIGSS32.DLL",IDOK);
#endif
    return GSS_S_EXT_COMPAT;

}
/**********************************************************************
**********************************************************************/
static void 
function_init(char * name, OM_uint32 (GSS_CALLCONV **pfunction)())
{
	long err;
#ifdef DEBUG
	char buf[256];
#endif
	char * libname = NULL;
	
	if (!gssapi_handle)
        {
#ifdef WIN32
		int result = 0;
		HMODULE module_gsi = NULL;
		HMODULE module_k5  = NULL;
		/*
		 * find out if we have two gssapi implementations
		 * Use simple message box, to ask which one
		 * as this does not require a lot of programing. 
		 */
			module_gsi = LoadLibrary("gssapi32gsi.dll");
			module_k5 = LoadLibrary("gssapi32k5.dll");
			if (module_gsi || module_k5)
			{
				if (module_gsi && module_k5)
				{
					 result = MessageBox(0,
"Select which GSSAPI to use:\n\n  YES - Globus GSI\n  NO  - Kerberos V5",
							"GSSAPI32.DLL",
							MB_YESNO | MB_ICONQUESTION | MB_TASKMODAL);
				}
				else 
					if (module_gsi) 
						result = IDYES;
	
				if (result == IDYES)
					gssapi_handle = module_gsi;
				else
					gssapi_handle = module_k5;
			}
			else
			{
				gssapi_handle = NULL;
			}
#else
      /* load shared lib - needs work DEE */
	  libname = (char *)getenv("GSS_LIB");

	  if (!libname)
	  {
		FILE *gss_file = NULL;
		char * gss_lib_default = GSS_LIB_FILE_NAME "." MY_FLAVOR ;
#ifdef DEBUG
		fprintf(stderr,"Using gss_lib_default %s\n",gss_lib_default);
#endif
		gss_file = fopen(gss_lib_default,"r");
		if (gss_file)
		{
			char gss_path[256];
			if (fgets(gss_path,255,gss_file))
			{
				gss_path[strlen(gss_path)-1] = '\0';
				libname = (char *)strdup(gss_path);
			}
			fclose(gss_file);
		}
	  }
      if (!libname)
	  {
	  	libname="/krb5/lib/libgssapi_krb5.so";
	  }
#ifdef DEBUG
	  fprintf(stderr,"CHOOSE lib %s",libname);
#endif
      gssapi_handle = dlopen(libname,  RTLD_LAZY);

#endif
			
	}
	if (gssapi_handle) 
	{
#ifdef DEBUG
		sprintf(buf,"First call to %s",name);
		MessageBox(0,buf,"GSIGSS32.DLL",IDOK);
#endif
#ifdef WIN32
		*pfunction = GetProcAddress(gssapi_handle, name);
#else
                *pfunction = dlsym(gssapi_handle, name);
#endif
	} 
	else
	{
#ifdef WIN32
		MessageBox(0,"Could not load gssapi32gsi.dll or gssapi32k5.dll","GSSAPI32.DLL",IDOK);
#else
		fprintf(stderr,"failed to dynamicly load %s\n",
		libname?libname:"(no lib name given)");
#endif
	}
	if (!*pfunction)
	{	
#ifdef WIN32
		err= GetLastError();
		sprintf(buf, "Error trying to resolve %s rc=%ld", name, err);
		MessageBox(0,buf,"GSIGSS32.DLL",IDOK);
#else 
		err = 1; /* errorno */
		/* A not found module, is not always an error,
	     * as this GSSAPI may not have implemented it
		 */
#ifdef DEBUG
		fprintf(stderr,"Error trying to resolve %s\n", name);
#endif
#endif
		*pfunction = function_error;
	}
}

/**************************************************************************************
**************************************************************************************/

OM_uint32 GSS_CALLCONV gss_acquire_cred
(OM_uint32 *              minor_status ,
 const gss_name_t         desired_name ,
 OM_uint32                time_req ,
 const gss_OID_set        desired_mechs ,
 gss_cred_usage_t         cred_usage ,
 gss_cred_id_t *          output_cred_handle ,
 gss_OID_set *            actual_mechs ,
 OM_uint32 *              time_rec 
 ) 
{
	COM_CODE("gss_acquire_cred")
	
     ms = (*function)(minor_status,
				 desired_name,
				 time_req,
				 desired_mechs,
				 cred_usage,
				 output_cred_handle,
				 actual_mechs,
				 time_rec);
	 return ms;
}


OM_uint32 GSS_CALLCONV gss_release_cred
(OM_uint32 *              minor_status ,
 gss_cred_id_t *          cred_handle 
) 
{ 
    COM_CODE("gss_release_cred")

    ms = (*function)(minor_status,
				 cred_handle);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_init_sec_context
(OM_uint32 *             minor_status ,
 const gss_cred_id_t     initiator_cred_handle ,
 gss_ctx_id_t *          context_handle ,
 const gss_name_t        target_name ,
 const gss_OID           mech_type ,
 OM_uint32               req_flags ,
 OM_uint32               time_req ,
 const gss_channel_bindings_t  input_chan_bindings ,
 const gss_buffer_t      input_token ,
 gss_OID *               actual_mech_type ,
 gss_buffer_t            output_token ,
 OM_uint32 *             ret_flags ,
 OM_uint32 *             time_rec 
) 
{
    COM_CODE("gss_init_sec_context")

    ms = (*function)(minor_status,
				 initiator_cred_handle,
				 context_handle ,
				 target_name ,
				 mech_type,
				 req_flags,
				 time_req,
				 input_chan_bindings,
				 input_token,
				 actual_mech_type,
				 output_token,
				 ret_flags,
				 time_rec);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_accept_sec_context
(OM_uint32 *              minor_status ,
 gss_ctx_id_t *           context_handle ,
 const gss_cred_id_t      acceptor_cred_handle ,
 const gss_buffer_t       input_token_buffer ,
 const gss_channel_bindings_t  input_chan_bindings ,
 gss_name_t *             src_name ,
 gss_OID *                mech_type ,
 gss_buffer_t             output_token ,
 OM_uint32 *              ret_flags ,
 OM_uint32 *              time_rec ,
 gss_cred_id_t *          delegated_cred_handle 
) 
{ 
    COM_CODE("gss_accept_sec_context")

    ms = (*function)(minor_status,
				 context_handle,
				 acceptor_cred_handle,
				 input_token_buffer,
				 input_chan_bindings,
				 src_name,
				 mech_type,
				 output_token,
				 ret_flags,
				 time_rec,
				 delegated_cred_handle);
	return ms;
 }


OM_uint32 GSS_CALLCONV gss_process_context_token
(OM_uint32 *              minor_status ,
 const gss_ctx_id_t       context_handle ,
 const gss_buffer_t       token_buffer 
)
{ 
    COM_CODE("gss_process_context_token")

    ms = (*function)(minor_status,
				 context_handle,
				 token_buffer);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_delete_sec_context
(OM_uint32 *              minor_status ,
 gss_ctx_id_t *           context_handle ,
 gss_buffer_t             output_token 
)
{
    COM_CODE("gss_delete_sec_context")
	
    ms = (*function)(minor_status,
				 context_handle,
				 output_token);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_context_time
(OM_uint32 *              minor_status ,
 const gss_ctx_id_t       context_handle ,
 OM_uint32 *               time_rec 
)
{ 
    COM_CODE("gss_context_time")

    ms = (*function)(minor_status,
				 context_handle,
				 time_rec);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_get_mic
(OM_uint32 *              minor_status ,
 const gss_ctx_id_t       context_handle ,
 gss_qop_t                qop_req ,
 const gss_buffer_t       message_buffer ,
 gss_buffer_t              message_token 
)
{
    COM_CODE("gss_get_mic")

    ms = (*function)(minor_status,
				 context_handle,
				 qop_req,
				 message_buffer,
				 message_token);
	return ms;
}



OM_uint32 GSS_CALLCONV gss_verify_mic
(OM_uint32 *              minor_status ,
 const gss_ctx_id_t       context_handle ,
 const gss_buffer_t       message_buffer ,
 const gss_buffer_t       token_buffer ,
 gss_qop_t *               qop_state 
)
{ 
    
    COM_CODE("gss_verify_mic")

    ms = (*function)(minor_status,
				 context_handle,
				 message_buffer,
				 token_buffer,
				 qop_state);
	return ms;
}



OM_uint32 GSS_CALLCONV gss_wrap
(OM_uint32 *              minor_status ,
 const gss_ctx_id_t       context_handle ,
 int                      conf_req_flag ,
 gss_qop_t                qop_req ,
 const gss_buffer_t       input_message_buffer ,
 int *                    conf_state ,
 gss_buffer_t              output_message_buffer 
) 
{
    COM_CODE("gss_wrap")

    ms = (*function)(minor_status,
				 context_handle,
				 conf_req_flag,
				 qop_req,
				 input_message_buffer,
				 conf_state,
				 output_message_buffer);
	return ms;
}



OM_uint32 GSS_CALLCONV gss_unwrap
(OM_uint32 *              minor_status ,
 const gss_ctx_id_t       context_handle ,
 const gss_buffer_t       input_message_buffer ,
 gss_buffer_t             output_message_buffer ,
 int *                    conf_state ,
 gss_qop_t *               qop_state 
)
{ 
    COM_CODE("gss_unwrap")

    ms = (*function)(minor_status,
				 context_handle,
				 input_message_buffer,
				 output_message_buffer,
				 conf_state,
				 qop_state);
	return ms;
}



OM_uint32 GSS_CALLCONV gss_display_status
(OM_uint32 *              minor_status ,
 OM_uint32                status_value ,
 int                      status_type ,
 const gss_OID            mech_type ,
 OM_uint32 *              message_context ,
 gss_buffer_t              status_string 
) 
{
    COM_CODE("gss_display_status")

    ms = (*function)(minor_status,
				 status_value,
				 status_type,
				 mech_type,
				 message_context,
				 status_string);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_indicate_mechs
(OM_uint32 *              minor_status ,
 gss_OID_set *             mech_set 
)
{ 
    COM_CODE("gss_indicate_mechs")

    ms = (*function)(minor_status,
				 mech_set);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_compare_name
(OM_uint32 *              minor_status ,
 const gss_name_t         name1 ,
 const gss_name_t         name2 ,
 int *                     name_equal 
) 
{ 
    COM_CODE("gss_compare_name")

    ms = (*function)(minor_status,
				 name1,
				 name2,
				 name_equal);
	return ms;
}

 
OM_uint32 GSS_CALLCONV gss_display_name
(OM_uint32 *              minor_status ,
 const gss_name_t         input_name ,
 gss_buffer_t             output_name_buffer ,
 gss_OID *                 output_name_type 
)
{
    COM_CODE("gss_display_name")

    ms = (*function)(minor_status,
				 input_name,
				 output_name_buffer,
				 output_name_type);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_import_name
(OM_uint32 *              minor_status ,
 const gss_buffer_t       input_name_buffer ,
 const gss_OID            input_name_type ,
 gss_name_t *              output_name 
)
{
    COM_CODE("gss_import_name")

    ms = (*function)(minor_status,
				 input_name_buffer,
				 input_name_type,
				 output_name);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_export_name
(OM_uint32  *             minor_status ,
 const gss_name_t         input_name ,
 gss_buffer_t              exported_name 
)
{
    COM_CODE("gss_export_name")

    ms = (*function)(minor_status,
				 input_name,
				 exported_name);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_release_name
(OM_uint32 *              minor_status ,
 gss_name_t *              input_name 
)
{
    COM_CODE("gss_release_name")

    ms = (*function)(minor_status,
				 input_name);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_release_buffer
(OM_uint32 *              minor_status ,
 gss_buffer_t              buffer 
)
{
    COM_CODE("gss_release_buffer")

    ms = (*function)(minor_status,
				 buffer);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_release_oid_set
(OM_uint32 *              minor_status ,
 gss_OID_set *             set 
)
{
    COM_CODE("gss_release_oid_set")

    ms = (*function)(minor_status,
				 set);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_inquire_cred
(OM_uint32 *              minor_status ,
 const gss_cred_id_t      cred_handle ,
 gss_name_t *             name ,
 OM_uint32 *              lifetime ,
 gss_cred_usage_t *       cred_usage ,
 gss_OID_set *             mechanisms 
)
{
    COM_CODE("gss_inquire_cred")
	
    ms = (*function)(minor_status,
				 cred_handle,
				 name,
				 lifetime,
				 cred_usage,
				 mechanisms);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_inquire_context 
(OM_uint32 *              minor_status ,
 const gss_ctx_id_t       context_handle ,
 gss_name_t *             src_name ,
 gss_name_t *             targ_name ,
 OM_uint32 *              lifetime_rec ,
 gss_OID *                mech_type ,
 OM_uint32 *              ctx_flags ,
 int *                    locally_initiated ,
 int *                     open 
)
{
    COM_CODE("gss_inquire_context")
	
    ms = (*function)(minor_status,
				 context_handle,
				 src_name,
				 targ_name,
				 lifetime_rec,
				 mech_type,
				 ctx_flags,
				 locally_initiated,
				 open);
	return ms;
}

 
OM_uint32 GSS_CALLCONV gss_wrap_size_limit 
(OM_uint32 *              minor_status ,
 const gss_ctx_id_t       context_handle ,
 int                      conf_req_flag ,
 gss_qop_t                qop_req ,
 OM_uint32                req_output_size ,
 OM_uint32 *               max_input_size 
)
{
    COM_CODE("gss_wrap_size_limit")

    ms = (*function)(minor_status,
				 context_handle,
				 conf_req_flag,
				 qop_req,
				 req_output_size,
				 max_input_size);
	return ms;
}



OM_uint32 GSS_CALLCONV gss_add_cred 
(OM_uint32 *              minor_status ,
 const gss_cred_id_t      input_cred_handle ,
 const gss_name_t         desired_name ,
 const gss_OID            desired_mech ,
 gss_cred_usage_t         cred_usage ,
 OM_uint32                initiator_time_req ,
 OM_uint32                acceptor_time_req ,
 gss_cred_id_t *          output_cred_handle ,
 gss_OID_set *            actual_mechs ,
 OM_uint32 *              initiator_time_rec ,
 OM_uint32 *               acceptor_time_rec 
)
{
    COM_CODE("gss_add_cred")

    ms = (*function)(minor_status,
				 input_cred_handle,
				 desired_name,
				 desired_mech,
				 cred_usage,
				 initiator_time_req,
				 acceptor_time_req,
				 output_cred_handle,
				 actual_mechs,
				 initiator_time_rec,
				 acceptor_time_req);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_inquire_cred_by_mech 
(OM_uint32 *              minor_status ,
 const gss_cred_id_t      cred_handle ,
 const gss_OID            mech_type ,
 gss_name_t *             name ,
 OM_uint32 *              initiator_lifetime ,
 OM_uint32 *              acceptor_lifetime ,
 gss_cred_usage_t *        cred_usage 
)
{
    COM_CODE("gss_inquire_cred_by_mech")

    ms = (*function)(minor_status,
				 cred_handle,
				 mech_type,
				 name,
				 initiator_lifetime,
				 acceptor_lifetime,
				 cred_usage);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_export_sec_context
(OM_uint32 *              minor_status ,
 gss_ctx_id_t *           context_handle ,
 gss_buffer_t              interprocess_token 
)
{
    COM_CODE("gss_export_sec_context")

    ms = (*function)(minor_status,
				 context_handle,
				 interprocess_token);
	return ms;
}



OM_uint32 GSS_CALLCONV gss_import_sec_context 
(OM_uint32 *              minor_status ,
 const gss_buffer_t       interprocess_token ,
 gss_ctx_id_t *            context_handle 
)
{
    COM_CODE("gss_import_sec_context")

     ms = (*function)(minor_status,
				 interprocess_token,
				 context_handle);
	return ms;
}


OM_uint32 GSS_CALLCONV gss_create_empty_oid_set
(OM_uint32 *              minor_status ,
 gss_OID_set *             oid_set 
)
{
    COM_CODE("gss_create_empty_oid_set")

    ms = (*function)(minor_status,
				 oid_set);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_add_oid_set_member
(OM_uint32 *              minor_status ,
 const gss_OID            member_oid ,
 gss_OID_set *             oid_set 
)
{
    COM_CODE("gss_add_oid_set_number")

    ms = (*function)(minor_status,
				 member_oid,
				 oid_set);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_test_oid_set_member
(OM_uint32 *              minor_status ,
 const gss_OID            member ,
 const gss_OID_set        set ,
 int *                    present 
)
{
    COM_CODE("gss_test_oid_set_member")

    ms = (*function)(minor_status,
				 member,
				 set,
				 present);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_inquire_names_for_mech
(OM_uint32 *              minor_status ,
 const gss_OID            mechanism ,
 gss_OID_set *            name_types 
)
{
    COM_CODE("gss_inquire_names_for_mech")

    ms = (*function)(minor_status,
				 mechanism,
				 name_types);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_inquire_mechs_for_name
(OM_uint32 *              minor_status ,
 const gss_name_t         input_name ,
 gss_OID_set *            mech_types 
)
{
    COM_CODE("gss_inquire_mechs_for_name")

    ms = (*function)(minor_status,
				 input_name,
				 mech_types);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_canonicalize_name
(OM_uint32 *              minor_status ,
 const gss_name_t         input_name ,
 const gss_OID            mech_type ,
 gss_name_t *             output_name 
)
{
    COM_CODE("gss_canonicalize_name")

    ms = (*function)(minor_status,
				 input_name,
				 mech_type,
				 output_name);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_duplicate_name
(OM_uint32 *              minor_status ,
 const gss_name_t         src_name ,
 gss_name_t *             dest_name 
)
{
    COM_CODE("gss_duplicate_name")

    ms = (*function)(minor_status,
				 src_name,
				 dest_name);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_sign
(OM_uint32 *         minor_status,
 gss_ctx_id_t        context_handle,
 int                 qop_req,
 gss_buffer_t        message_buffer,
 gss_buffer_t        message_token
)
{
    COM_CODE("gss_sign")

    ms = (*function)(minor_status,
				 context_handle,
				 qop_req,
				 message_buffer,
				 message_token);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_verify
(OM_uint32 *        minor_status,
 gss_ctx_id_t       context_handle,
 gss_buffer_t       message_buffer,
 gss_buffer_t       token_buffer,
 int *              qop_state
)
{
    COM_CODE("gss_verify")

    ms = (*function)(minor_status,
				 context_handle,
				 message_buffer,
				 token_buffer,
				 qop_state);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_seal
(OM_uint32 *        minor_status,
 gss_ctx_id_t       context_handle,
 int                conf_req_flag,
 int                qop_req,
 gss_buffer_t       input_message_buffer,
 int *              conf_state,
 gss_buffer_t       output_message_buffer
)
{
    COM_CODE("gss_seal")

    ms = (*function)(minor_status,
				 context_handle,
				 conf_req_flag,
				 qop_req,
				 input_message_buffer,
				 conf_state,
				 output_message_buffer);
	return ms;
}

OM_uint32 GSS_CALLCONV gss_unseal
(OM_uint32 *        minor_status,
 gss_ctx_id_t       context_handle,
 gss_buffer_t       input_message_buffer,
 gss_buffer_t       output_message_buffer,
 int *              conf_state,
 int *              qop_state
)
{
    COM_CODE("gss_unseal")

    ms = (*function)(minor_status,
				 context_handle,
				 input_message_buffer,
				 output_message_buffer,
				 conf_state,
				 qop_state);
	return ms;
}

OM_uint32 
GSS_CALLCONV gss_create_empty_buffer_set
    (OM_uint32 * minor_status,
     gss_buffer_set_t * buffer_set
)
{
	COM_CODE("gss_create_empty_buffer_set")
	
	ms = (*function)(minor_status,
				  buffer_set);
	return ms;
}

    
OM_uint32 
GSS_CALLCONV gss_add_buffer_set_member
    (OM_uint32 * minor_status,
     const gss_buffer_t member_buffer,
     gss_buffer_set_t * buffer_set
)
{
	COM_CODE("gss_add_buffer_set_member")

	ms = (*function)(minor_status,
				  member_buffer,
				  buffer_set);
	return ms;
}
    

OM_uint32 
GSS_CALLCONV gss_release_buffer_set
    (OM_uint32 * minor_status,
     gss_buffer_set_t * buffer_set
)
{
	COM_CODE("gss_release_buffer_set")

	ms = (*function)(minor_status,
				 buffer_set);
	return ms;
}


OM_uint32 
GSS_CALLCONV gss_import_cred
    (OM_uint32 * minor_status,
     gss_cred_id_t * cred_handle,
     const gss_OID desired_mech,
     OM_uint32 option_req,
     const gss_buffer_t import_buffer,
     OM_uint32 time_req,
     OM_uint32 * time_rec
)
{
	COM_CODE("gss_import_cred")

	ms = (*function)(minor_status,
				  cred_handle,
				  desired_mech,
				  option_req,
				  import_buffer,
				  time_req,
				  time_rec);
	return ms;
}


OM_uint32
GSS_CALLCONV gss_export_cred
    (OM_uint32 * minor_status,
     const gss_cred_id_t cred_handle,
     const gss_OID  desired_mech,
     OM_uint32 option_req,
     gss_buffer_t output_buffer
)
{
	COM_CODE("gss_export_cred")

	ms = (*function)(minor_status,
				  cred_handle,
				  desired_mech,
				  option_req,
				  output_buffer);
	return ms;
}
	


OM_uint32
GSS_CALLCONV gss_init_delegation
    (OM_uint32 *  minor_status,
     const gss_ctx_id_t context_handle,
     const gss_cred_id_t cred_handle,
     const gss_OID desired_mech,
     const gss_OID_set extension_oids,
     const gss_buffer_set_t extension_buffers,
     const gss_buffer_t input_token,
     OM_uint32 req_flags,
     OM_uint32 time_req,
     gss_buffer_t output_token
)
{
	COM_CODE("gss_init_delegation")

	ms = (*function)(minor_status,
				  context_handle,  
				  cred_handle,
				  desired_mech,
				  extension_oids,
				  extension_buffers,
				  input_token,
				  req_flags,
				  time_req,
				  output_token);
	return ms;
}


OM_uint32
GSS_CALLCONV gss_accept_delegation
    (OM_uint32 * minor_status,
     const gss_ctx_id_t context_handle,
     const gss_OID_set extension_oids,
     const gss_buffer_set_t extension_buffers,
     const gss_buffer_t input_token,
     OM_uint32 req_flags,
     OM_uint32 time_req,
     OM_uint32 * time_rec,
     gss_cred_id_t * delegated_cred_handle,
     gss_OID * mech_type,
     gss_buffer_t output_token
)
{
	COM_CODE("gss_accept_delegation")

	ms = (*function)(minor_status,
				 context_handle,
				 extension_oids,
				 extension_buffers,
				 input_token,
				 req_flags,
				 time_req,
				 time_rec,
				 delegated_cred_handle,
				 mech_type,
				 output_token);
	return ms;
}


OM_uint32
GSS_CALLCONV gss_inquire_sec_context_by_oid
    (OM_uint32 * minor_status,
     const gss_ctx_id_t context_handle,
     const gss_OID desired_object,
     gss_buffer_set_t * data_set
)
{
	COM_CODE("gss_inquire_sec_context_by_oid")

	ms = (*function)(minor_status,
				  context_handle,
				  desired_object,
				  data_set);
	return ms;
}


OM_uint32
GSS_CALLCONV gss_inquire_cred_by_oid
    (OM_uint32 * minor_status,
     const gss_cred_id_t context_handle,
     const gss_OID desired_object,
     gss_buffer_set_t * data_set
)
{
	COM_CODE("gss_inquire_cred_by_oid")

	ms = (*function)(minor_status,
				  context_handle,  
				  desired_object,
				  data_set);
	return ms;
}



OM_uint32
GSS_CALLCONV gss_set_sec_context_option
    (OM_uint32 * minor_status,
     gss_ctx_id_t * context_handle,
     const gss_OID option,
     const gss_buffer_t value
)
{
	COM_CODE("gss_set_sec_context_option")

	ms = (*function)(minor_status,
				  context_handle,
				  option,
				  value);
	return ms;
}



OM_uint32
GSS_CALLCONV gss_set_group
    (OM_uint32 * minor_status,
     gss_name_t name,
     const gss_buffer_set_t group,
     const gss_OID_set group_types
)
{
	COM_CODE("gss_set_group")

	ms = (*function)(minor_status,
				  name,
				  group,
				  group_types);
	return ms;
}



OM_uint32
GSS_CALLCONV gss_get_group
    (OM_uint32 * minor_status,
     const gss_name_t name,
     gss_buffer_set_t * group,
     gss_OID_set * group_types
)
{
	COM_CODE("gss_get_group")

	ms = (*function)(minor_status,
				  name,
				  group,
				  group_types);
	return ms;
}


#ifdef GLOBUS_GSI_GSSAPI_MODULE
/* Globus GSI 2.2.4 is looking for activation routines.
 * It is looking for a globus_module_descriptor_t 
 * named globus_i_gsi_gssapi_module We need 
 * to simulate, as the Kerberos or other GSS mechs don't have it.
 * The use of the specific activation routines
 * violate the spirit if the GSSAPI. 
 */

static
int
mechglue_activate(void)
{
	static 
	globus_module_descriptor_t *globus_i_gsi_gssapi_real_module = NULL;
    OM_uint32 (GSS_CALLCONV *function)();
	int result=-1;

/* For now call the activation, could add to the g_initalize,
 * to call it, or save the entry, so when we are called, we will
 * call all the mech's activation routines. 
 */

if (!globus_i_gsi_gssapi_real_module)
{
		function_init("globus_i_gsi_gssapi_module", 
					 &function);
}

if (function && function != function_error)
{

	globus_i_gsi_gssapi_real_module = 
				(globus_module_descriptor_t *)function;
	result= globus_module_activate(globus_i_gsi_gssapi_real_module);
}
    return GLOBUS_SUCCESS;
}

static
int
mechglue_deactivate(void)
{
      /* We should try and run the list of mechs and deactive each */
      return GLOBUS_SUCCESS;
}
#endif
