/*
Package:  moab
Module:   MUH.c
Version:  3.2.6
Modified: Jul 20, 2004

Copyright:

  Copyright (C) 1999-2004 Cluster Resources, Inc

  All Rights Reserved

Disclaimer:

 THIS SOFTWARE IS PROVIDED AS IS AND CLUSTER RESOURCES INC (CRI) DISCLAIMS ALL WARRANTIES RELATING TO THE SOFTWARE, WHETHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  NEITHER CRI, NOR ANYONE INVOLVED IN THE CREATION, PRODUCTION, OR DELIVERY OF THE SOFTWARE SHALL BE LIABLE FOR ANY INDIRECT, CONSEQUENTIAL, OR INCIDENTAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE SOFTWARE EVEN IF CRI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR CLAIMS.  THE PERSON OR ENTITY USING THE SOFTWARE BEARS ALL RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE.
*/

#include "moab.h"
#include "msched-proto.h"  

#ifdef __MOPENSSL
#include "moab-openssl.h"
#endif /* __MOPENSSL */

extern mlog_t mlog;
extern const char *MService[];

extern msched_t MSched;

#define BUF_SIZ  1024


/* prototypes */

int UHSendFailure(msocket_t *,char *);
int UHSendResponse(msocket_t *,char *);




int MUHInitialize()

  {
  MSched.HTTPProcessF = MUHProcessRequest;

  return(SUCCESS);
  }  /* END MUHInitialize() */




int MUHProcessRequest(

  msocket_t *S,
  char      *Header)

  {
  int  CIndex;
  int  index;

  char tmpLine[MAX_MLINE];

  char HTTPCommand[MAX_MNAME];
  char HTTPProtocol[MAX_MNAME];
  char MRequest[MAX_MLINE];

  char *MCommand;
  char *TokPtr;

  char TBuffer[MAX_MBUFFER];
  char SBuffer[MAX_MBUFFER];
  long SBufSize;

  char *ptr;

  /* NOTE:  9 characters already read into Header */

  for (index = 0;MSched.Admin3User[index][0] != '\0';index++)
    {
    if (!strcmp(MSched.Admin3User[index],"ALL"))
      {
      break;
      }
    }    /* END for (index) */

  if (MSched.Admin3User[index][0] == '\0')
    {
    UHSendFailure(S,"request not authorized");
 
    return(FAILURE);
    }

  strncpy(tmpLine,Header,9);

  /* read in remaining HTTP header */

  ptr = &tmpLine[9];

  if (MSURecvPacket(
        S->sd,
        &ptr,
        200,
	NULL,
        1000000) == FAILURE)
    {
    DBG(1,fSOCK) DPrint("ALERT:    cannot receive packet (%d bytes requested)\n",
      200);
 
    /* return(FAILURE); */
    }

  /* determine requested command */

  MUSScanF(tmpLine,"%x%s %x%s %x%s",
    sizeof(HTTPCommand),
    HTTPCommand,
    sizeof(MRequest),
    MRequest,
    sizeof(HTTPProtocol),
    HTTPProtocol);

  if (strcmp(HTTPCommand,"GET"))
    {
    UHSendFailure(S,"request not supported");

    return(FAILURE);
    }

  if ((MCommand = MUStrTok(MRequest," \t\n?/",&TokPtr)) == NULL)
    {
    UHSendFailure(S,"cannot process request");
 
    return(FAILURE);
    }

  if ((CIndex = MUGetIndex(MCommand,MService,0,svcNONE)) == svcNONE)
    {
    UHSendFailure(S,"command not supported");
 
    return(FAILURE);
    }

  SBufSize = (long)sizeof(SBuffer);       

  /* handle request */

  switch(CIndex)
    {
    case svcShowQ:

      UIQueueShowAllJobs(TBuffer,&SBufSize,0);

      UIFormatShowAllJobs(TBuffer,SBuffer,mfmHTTP);

      break;

    default:

      UHSendFailure(S,"command not handled");
 
      return(FAILURE);

      /*NOTREACHED*/
 
      break;
    }  /* END switch(cindex) */

  UHSendResponse(S,SBuffer);

  return(SUCCESS);
  }  /* MUHProcessRequest() */




int UHSendResponse(

  msocket_t *S,
  char      *Buffer)

  {
  char tmpBody[MAX_MBUFFER];
  char tmpHeader[MAX_MBUFFER];

  if ((S == NULL) || (Buffer == NULL))
    {
    return(FAILURE);
    }

  /* create body */

  sprintf(tmpBody,"<HTML><BODY><B><TT>%s</TT></B></BODY></HTML>\r\n",
    Buffer);

  /* create header */

  sprintf(tmpHeader,"HTTP/1.0 200 OK\r\n");
  sprintf(tmpHeader,"%sServer: Moab/3.0.7\r\n",
    tmpHeader);
/*
  sprintf(tmpHeader,"%sConnection: close\r\n",
    tmpHeader);
*/
  sprintf(tmpHeader,"%sDate: Tue, 22 May 2001 17:54:00 GMT\r\n",
    tmpHeader);
  sprintf(tmpHeader,"%sLast-Modified: Tue, 22 May 2001 13:59:59 GMT\r\n",
    tmpHeader);
  sprintf(tmpHeader,"%sContent-Type: text/html\r\n",
    tmpHeader);
  sprintf(tmpHeader,"%sContent-Length: %d\r\n",
    tmpHeader,
    strlen(tmpBody));
  strcat(tmpHeader,"\r\n");

  /* header complete */        

  MUStrCat(tmpHeader,tmpBody,sizeof(tmpHeader));

  MSUSendPacket(S->sd,tmpHeader,strlen(tmpHeader),1000000);    

  return(SUCCESS);
  }  /* END UHSendResponse() */




int UHSendFailure(

  msocket_t *S,
  char      *Message)

  {
  char tmpHeader[MAX_MLINE];
  char tmpBody[MAX_MLINE];

  if ((S == NULL) || (Message == NULL))
    {
    return(FAILURE);
    }

  /* create body */
 
  sprintf(tmpBody,"<HTML><BODY><B>ERROR:  %s</B></BODY></HTML>\r\n",
    Message);
 
  /* create header */
 
  sprintf(tmpHeader,"HTTP/1.0 200 OK\r\n");
  sprintf(tmpHeader,"%sServer: Moab/%s\r\n",
    tmpHeader,
    MSCHED_VERSION);
  sprintf(tmpHeader,"%sDate: Tue, 22 May 2001 17:54:00 GMT\r\n",
    tmpHeader);
  sprintf(tmpHeader,"%sLast-Modified: Tue, 22 May 2001 13:59:59 GMT\r\n",
    tmpHeader);
  sprintf(tmpHeader,"%sContent-Type: text/html\r\n",
    tmpHeader);
  sprintf(tmpHeader,"%sContent-Length: %d\r\n",
    tmpHeader,
    strlen(tmpBody));
  strcat(tmpHeader,"\r\n");
 
  /* header complete */
 
  MUStrCat(tmpHeader,tmpBody,sizeof(tmpHeader));
 
  MSUSendPacket(S->sd,tmpHeader,strlen(tmpHeader),1000000);

  sleep(1);
 
  return(SUCCESS);
  }  /* END UHSendFailure() */


#ifdef __MOPENSSL

int UHSSLInit()

  {
  char    *CApath  = NULL;
  char    *CAfile  = NULL;
  char    *context = NULL;
  char    *dhfile  = NULL;
  int      badop   = 0;
  int      bugs    = 0;
  int      ret     = 1;
  int      off     = 0;
  int      no_tmp_rsa=0,no_dhe=0,nocert=0;
  int      state   = 0;
  SSL_METHOD *meth = NULL;
  char    *inrand  = NULL;

  SSL     *con     = NULL;   
  BIO     *sbio;         

  int      s;

  int      Port;

#ifndef NO_DH
  DH *dh           = NULL;
#endif

  SSL_CTX *ctx     = NULL;
 
#if !defined(NO_SSL2) && !defined(NO_SSL3)
  meth=SSLv23_server_method();
#elif !defined(NO_SSL3)
  meth=SSLv3_server_method();
#elif !defined(NO_SSL2)
  meth=SSLv2_server_method();
#endif
 
  SSL_load_error_strings();
  SSL_library_init();

  if ((ctx = SSL_CTX_new((SSL_METHOD *)SSLv3_server_method)) == NULL)
    {
    /* cannot create SSL context */

    return(FAILURE);
    }

  Port = MSched.ServerPort + 1;

  MSUInitialize(&MSched.SServerS,NULL,Port,MSched.ClientTimeout,(1 << TCP));

  if (MSUListen(&MSched.SServerS) == FAILURE)
    {
    /* cannot open SSL port */
 
    return(FAILURE);
    }

  return(SUCCESS);
  }  /* END UHSSLInit() */




int UHProcessSSLRequest(

  int sd)

  {
  int  rc;
  char RBuffer[MAX_MLINE];

  SSL  *con  = NULL;
  X509 *peer = NULL;

  char  buf[BUF_SIZ];

  if (con == NULL) 
    {
    if ((con = SSL_new(ctx)) == NULL)
      {
      /* cannot create SSL connection */

      return(FAILURE);
      }
    }

  SSL_set_fd(con,sd);

  if ((rc = SSL_accept(con)) != 1)
    {
    DBG(0,fCORE) DPrint("ALERT:    SSL failure in SSL_accept()  %s\n",
      SSL_get_error(con,rc));

    return(FAILURE);
    }

  PEM_write_bio_SSL_SESSION(
    bio_s_out,
    SSL_get_session(con));
 
  if ((peer = SSL_get_peer_certificate(con)) != NULL)
    {
    BIO_printf(bio_s_out,"Client certificate\n");
    PEM_write_bio_X509(bio_s_out,peer);
    X509_NAME_oneline(X509_get_subject_name(peer),buf,BUFSIZ);
    BIO_printf(bio_s_out,"subject=%s\n",buf);
    X509_NAME_oneline(X509_get_issuer_name(peer),buf,BUFSIZ);
    BIO_printf(bio_s_out,"issuer=%s\n",buf);
    X509_free(peer);
    }

  if ((rc = SSL_read(con,RBuffer,sizeof(RBuffer))) <= 0)
    {
    DBG(0,fCORE) DPrint("ALERT:    SSL failure in SSL_read()  %s\n",
      SSL_get_error(con,rc));
 
    return(FAILURE);
    }

  return(SUCCESS);
  }  /* END UHProcessSSLRequest() */


   

int UHGarbage()

  {
  char    *CApath  = NULL;
  char    *CAfile  = NULL;
  char    *context = NULL;
  char    *dhfile  = NULL;
  int      badop   = 0;
  int      bugs    = 0;
  int      ret     = 1;
  int      off     = 0;
  int      no_tmp_rsa=0,no_dhe=0,nocert=0;
  int      state   = 0;
  SSL_METHOD *meth = NULL;
  char    *inrand  = NULL;
 
  SSL     *con     = NULL;
  BIO     *sbio;
 
  int      s;
#ifndef NO_DH
  DH *dh           = NULL;
#endif
 
  SSL_CTX *ctx     = NULL;
 
#if !defined(NO_SSL2) && !defined(NO_SSL3)
  meth=SSLv23_server_method();
#elif !defined(NO_SSL3)
  meth=SSLv3_server_method();
#elif !defined(NO_SSL2)
  meth=SSLv2_server_method();
#endif
   
    if (context)
      {
      SSL_set_session_id_context(
        con, 
        (const unsigned char *)context,
        strlen((char *)context));
      }

  SSL_clear(con);
 
  sbio = BIO_new_socket(s,BIO_NOCLOSE);

  if (s_nbio_test)
    {
    BIO *test;
 
    test=BIO_new(BIO_f_nbio_test());
    sbio=BIO_push(test,sbio);
    }

  SSL_set_bio(con,sbio,sbio);
  SSL_set_accept_state(con);

  return(SUCCESS);
  }  /* END UHSSLInit() */
#endif /* __MOPENSSL */


/* END MUH.c */
