/*
Package:  moab
Module:   MNatI.c
Version:  3.2.6
Modified: Jul 20, 2004

Copyright:

  Copyright (C) 1999-2004 Cluster Resources, Inc

  All Rights Reserved

Disclaimer:

 THIS SOFTWARE IS PROVIDED AS IS AND CLUSTER RESOURCES INC (CRI) DISCLAIMS ALL WARRANTIES RELATING TO THE SOFTWARE, WHETHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  NEITHER CRI, NOR ANYONE INVOLVED IN THE CREATION, PRODUCTION, OR DELIVERY OF THE SOFTWARE SHALL BE LIABLE FOR ANY INDIRECT, CONSEQUENTIAL, OR INCIDENTAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE SOFTWARE EVEN IF CRI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR CLAIMS.  THE PERSON OR ENTITY USING THE SOFTWARE BEARS ALL RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE.
*/

/* Contains:                                   *
 *                                             */

#include "moab.h"
#include "msched-proto.h"

extern mlog_t    mlog;

extern msched_t    MSched;
extern mclass_t    MClass[];
extern mjob_t     *MJob[];
extern int         MGlobalTLock;
extern mrm_t       MRM[];
extern mattrlist_t MAList;
extern mnode_t    *MNode[];

extern const char *MNodeState[];

/* NOTE:  create serial launcher to set SID, obtain PID (NYI) */

/* NAT prototypes */

int MNatInitialize(mrm_t *,int *);
int MNatGetData(mrm_t *,int *);
int MNatJobStart(mjob_t *,mrm_t *,char *,int *);
int MNatJobRequeue(mjob_t *,mrm_t *,mjob_t **,char *,int *);
int MNatJobModify(mjob_t *,mrm_t *,char *,char *,char *,int *);
int MNatJobCancel(mjob_t *,mrm_t *,char *,char *,int *);
int MNatJobSuspend(mjob_t *,mrm_t *,char *,int *);
int MNatJobResume(mjob_t *,mrm_t *,char *,int *);
int MNatJobCheckpoint(mjob_t *,mrm_t *,int,char *,int *);
int MNatClusterQuery(mrm_t *,int *,char *,int *);
int MNatWorkloadQuery(mrm_t *,int *,int *);
int MNatJobLoad(char *,void *,mjob_t *,short *,mrm_t *);
int MNatJobUpdate(void *,mjob_t *,short *,mrm_t *);
int MNatNodeLoad(mnode_t *,void *,enum MNodeStateEnum,mrm_t *);
int MNatNodeUpdate(mnode_t *,void *,int,mrm_t *);
int __MNatJobGetState(mxml_t *,mrm_t *,char *,int *);
int __MNatNodeGetState(void *,char *,int *);
int MNatGetQueueInfo(mnode_t *,char C[][MAX_MNAME],char A[][MAX_MNAME]);
int __MNatGetTaskList(char *,short *,int *,int *);
int __MNatJobSetAttr(mjob_t *,char *,char *);
int __MNatNodeSetAttr(mnode_t *,mrm_t *,char *,char *);
char *__MNatGetErrMsg(int);
int __MNatDoCommand(char *,char *,char *);

/* END NAT prototypes */



int MNatLoadModule(

  mrmfunc_t *F)  /* I */

  {
  if (F == NULL)
    {
    return(FAILURE);
    }

  F->ClusterQuery   = MNatClusterQuery;
  F->JobCancel      = MNatJobCancel;
  F->JobCheckpoint  = NULL;
  F->JobModify      = NULL;
  F->JobQuery       = NULL;
  F->JobRequeue     = NULL;
  F->JobResume      = NULL;
  F->JobStart       = MNatJobStart;
  F->JobSuspend     = NULL;
  F->QueueQuery     = NULL;
  F->ResourceModify = NULL;
  F->ResourceQuery  = NULL;
  F->RMInitialize   = MNatInitialize;
  F->RMQuery        = NULL;
  F->WorkloadQuery  = MNatWorkloadQuery;

  return(SUCCESS);
  }  /* END MNatLoadModule() */




int MNatInitialize(

  mrm_t *R,   /* I */
  int   *SC)  /* I */

  {
  const char *FName = "MNatInitialize";

  DBG(1,fNAT) DPrint("%s(%s,SC)\n",
    FName,
    (R != NULL) ? R->Name : "NULL");

  if (R == NULL)
    {
    return(FAILURE);
    }

  /* NO-OP */

  return(SUCCESS);
  }  /* END MNatInitialize() */




int MNatClusterQuery(

  mrm_t *R,      /* I */
  int   *RCount, /* O */
  char  *EMsg,
  int   *SC)     /* I */

  {
  int nindex;

  mnode_t *N;

  enum MNodeStateEnum OldState;
  enum MNodeStateEnum NewState;

  char Response[MAX_MLINE];

  const char *FName = "MNatClusterQuery";

  DBG(1,fNAT) DPrint("%s(%s,RCount,SC)\n",
    FName,
    (R != NULL) ? R->Name : "NULL");

  if (RCount != NULL)
    *RCount = 0;

  for (nindex = 0;nindex < MAX_MNODE;nindex++)
    {
    if (MSched.ComputeHost[nindex] == NULL)
      break;
  
    if ((MSched.ComputeN[nindex] == NULL) &&
        (MNodeAdd(MSched.ComputeHost[nindex],&MSched.ComputeN[nindex]) == FAILURE))
      {
      /* cannot add compute node */

      continue;
      }

    N = MSched.ComputeN[nindex];

    if (RCount != NULL)
      (*RCount)++;

    /* contact compute host */

    OldState = N->State;

    if (__MNatDoCommand(N->Name,MNAT_GETLOADCMD,Response) == FAILURE)
      {
      NewState = mnsDown;
      }
    else
      {
      NewState = mnsIdle;
      }

    MRMNodePreLoad(N,NewState,R);
 
    MNatNodeLoad(N,(void *)Response,NewState,R); 

    MRMNodePostLoad(N);

    DBG(2,fNAT)
      MNodeShow(N);
    }  /* END for (nindex) */ 

  return(SUCCESS);
  }  /* END MNatClusterQuery() */




int __MNatDoCommand(

  char *HostName,  /* I */
  char *Cmd,       /* I */
  char *Response)  /* O */

  {
  char tmpLine[MAX_MLINE];

  const char *FName = "__MNatDoCommand";

  DBG(1,fNAT) DPrint("%s(%s,%s,Response)\n",
    FName,
    (HostName != NULL) ? HostName : "NULL",
    (Cmd != NULL) ? Cmd : "NULL");

  if (Response != NULL)
    Response[0] = '\0';

  if ((HostName == NULL) || (Cmd == NULL) || (Response == NULL))
    {
    return(FAILURE);
    }

  sprintf(tmpLine,"%s %s \"%s 2>&1\"",
    MNAT_RCMD,
    HostName,
    Cmd);
 
  if (MUReadPipe(tmpLine,Response,MAX_MLINE) == FAILURE)
    {
    return(FAILURE);
    }

  return(SUCCESS);
  }  /* END __MNatDoCommand() */




int MNatWorkloadQuery(

  mrm_t *R,      /* I */
  int   *JCount, /* O */
  int   *SC)     /* I */

  {
  const char *FName = "MNatWorkloadQuery";

  DBG(1,fNAT) DPrint("%s(%s,JCount,SC)\n",
    FName,
    (R != NULL) ? R->Name : "NULL");

  if (JCount != NULL)
    *JCount = 0;

  /* NYI */

  return(SUCCESS);
  }  /* END MNatWorkloadQuery() */




int MNatJobStart(

  mjob_t *J,   /* I */
  mrm_t  *R,   /* I */
  char   *Msg, /* O (optional) */
  int    *SC)  /* O (optional) */

  {
  char Response[MAX_MLINE];

  const char *FName = "MNatJobStart";

  DBG(1,fNAT) DPrint("%s(%s,%s,Msg,SC)\n",
    FName,
    (J != NULL) ? J->Name : "NULL",
    (R != NULL) ? R->Name : "NULL");

  if ((J == NULL) || (R == NULL))
    {
    return(FAILURE);
    }

  if (J->NodeList[0].N == NULL)
    {
    /* invalid host list */

    return(FAILURE);
    }

  if (J->E.Cmd == NULL)
    {
    /* no executable specified */

    return(FAILURE);
    }

  if (__MNatDoCommand(J->NodeList[0].N->Name,J->E.Cmd,Response) == FAILURE)
    {
    /* cannot execute job */

    return(FAILURE);
    }

  DBG(1,fSSS) DPrint("INFO:     job '%s' successfully started\n",
    J->Name);
 
  return(SUCCESS);
  }  /* END MNatJobStart() */




int MNatJobCancel(

  mjob_t *J,        /* I */
  mrm_t  *R,        /* I */
  char   *Message,  /* I */
  char   *ErrMsg,   /* O (optional) */
  int    *SC)       /* O (optional) */

  {
  char tmpLine[MAX_MLINE];
  char Response[MAX_MLINE];

  const char *FName = "MNatJobCancel";

  DBG(1,fNAT) DPrint("%s(%s,%s,%s,ErrMsg,SC)\n",
    FName,
    (J != NULL) ? J->Name : "NULL",
    (R != NULL) ? R->Name : "NULL",
    (Message != NULL) ? Message : "NULL");

  if ((J == NULL) || (R == NULL))
    {
    return(FAILURE);
    }

  if (J->NodeList[0].N == NULL)
    {
    /* invalid host list */

    return(FAILURE);
    }

  if (J->E.PID <= 1)
    {
    /* process id not available */

    return(FAILURE);
    }

  sprintf(tmpLine,"%s %s %ld",
    MNAT_CANCELCMD,
    MNAT_CANCELSIG,
    J->E.PID);

  if (__MNatDoCommand(J->NodeList[0].N->Name,tmpLine,Response) == FAILURE)
    {
    /* cannot execute job */

    return(FAILURE);
    }

  return(FAILURE);
  }  /* END MNatJobCancel() */



int MNatNodeLoad(
 
  mnode_t *N,   /* I (modified) */
  void    *NP,  /* I */
  enum MNodeStateEnum NewState, /* I */
  mrm_t   *R)   /* I */

  {
  char *ptr;

  if ((N == NULL) || (NP == NULL))
    {
    return(FAILURE);
    }

  MNodeSetState(N,NewState,0);

  /* FORMAT:  <IDLETIME> */

  ptr = (char *)NP;

  N->ARes.Procs = 1;
  N->CRes.Procs = 1;

  N->Load = (double)1.0 - ((double)strtol(ptr,NULL,0) / 100.0);

  return(SUCCESS);
  }  /* MNatNodeLoad() */


/* END MNatI.c */
