/*
Package:  moab
Module:   MCluster.c
Version:  3.2.6p18

Copyright:

  Copyright (C) 1999-2006 Cluster Resources, Inc

  All Rights Reserved

-----------------------------------------------------------------------------
Moab Workload Manager - End User License

This product was created by Cluster Resources, Inc. and is protected by
copyright and patent law.

Copyright (C) 1999-2006 Cluster Resources, Inc., all rights reserved.
Moab Workload Manager, Moab Cluster Scheduler and Moab Scheduler
are trademarks of Cluster Resources, Inc.

This SOFTWARE is bound by an 'End User Subscription License' (LICENSE) from
Cluster Resources Inc.  The conditions of the 'End User Subscription
License' (LICENSE) include, but are not limited to, the conditions described
below.

THE SOFTWARE IS PROVIDED AS IS, AND CLUSTER RESOURCES, INC. (CRI) AND ALL
CONTRIBUTING PARTIES DISCLAIM ALL WARRANTIES RELATING TO THE SOFTWARE,
WHETHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  NEITHER
CRI NOR ANYONE INVOLVED IN THE CREATION, PRODUCTION, OR DELIVERY OF THE
SOFTWARE SHALL BE LIABLE FOR ANY INDIRECT, CONSEQUENTIAL, OR INCIDENTAL
DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE SOFTWARE EVEN IF CRI
HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR CLAIMS.  IN NO EVENT
SHALL CRI'S LIABILITY FOR ANY DAMAGES EXCEED THE CONSIDERATION PAID FOR THE
LICENSE TO USE THE SOFTWARE, REGARDLESS OF THE FORM OF CLAIM.  THE PERSON OR
ENTITY USING THE SOFTWARE BEARS ALL RISK AS TO THE QUALITY AND PERFORMANCE
OF THE SOFTWARE.

By installing or using this SOFTWARE you are accepting a non-exclusive 'End
User Subscription License' (LICENSE) from Cluster Resources Inc. and are
bound to abide by the following conditions:

1.  Inclusion of Notice and Disclaimer

  All copies of the SOFTWARE, whether or not for redistribution and whether
or not in source code or in binary form must include a conspicuous and
appropriate publication of the above copyright notice and disclaimer.

2. Usage

  Binary forms of this SOFTWARE may be used by any 'End User' organization
pursuant to the conditions of this and other associated LICENSES for the
duration of the subscription license granted.  An 'End User' organization is
defined as an organization that is using this SOFTWARE on their own systems
and is not commercially redistributing, modifying, supporting, or providing
other services specific to this SOFTWARE to other organizations for profit.

3.  Modifications

  'End User' may solicit the services of Cluster Resources Inc. of Cluster
Resources Inc. to modify or provide services for this SOFTWARE. Available
services include but are not limited to technical support, training,
consultation or optimization services. Any unauthorized partner that desires
to become an 'Authorized Distribution and Services Partner' of Cluster
Resources, Inc. may contact us at support.com.  'End User'
organizations that desire services from Cluster Resources Inc., or an
'Authorized Distribution and Services Partner' may contact us using the same
email listed above.

4.  Distribution

  No redistribution of this product is permitted without express prior
written permission.

5. Communications about and Endorsement of SOFTWARE and Products/Software
Derived from the SOFTWARE

  The name 'Moab Scheduling System', 'Moab Cluster Scheduler', 'Moab Scheduler',
'Moab Workload Manager' or any of its variants must not otherwise be used to
endorse or to promote products derived from the SOFTWARE without prior written
permission from CRI.

  Products derived from or incorporating the SOFTWARE in whole or in part
shall not contain as part of the product's name any form of the terms 'Cluster
Resources, Inc.', 'CRI', 'Moab', 'Moab Scheduling System', 'Moab Cluster
Scheduler', 'Moab Scheduler', 'Moab Workload Manager', or 'Supercluster
Development Group' unless prior written permission has been received from
Cluster Resources, Inc.

  All advertising materials for products that use or incorporate features of
the SOFTWARE must display the following acknowledgement: 'This product
includes software developed by Cluster Resources, Inc. for use in the Moab
Scheduling System.'

6.  Acceptance of this LICENSE

  It is not required that you accept this LICENSE; however, if you do not
accept the terms of this LICENSE, you are prohibited by law from installing,
using, modifying or distributing the SOFTWARE or any of its derivative works.
Therefore, by installing, using, modifying or distributing the SOFTWARE (or
any of its derivative works), you have agreed to this LICENSE and have
accepted all its terms and conditions.

  If any portion of this LICENSE is held invalid or unenforceable under any
particular circumstance, the balance of the LICENSE will continue to apply.

------------------------------------------------------------------------------
*/


int MClusterUpdateNodeState()

  {
  int nindex;
  int rqindex;
 
  mreq_t *RQ;
  mjob_t *J;
 
  short TotalTaskDed[MAX_MNODE];
  short TotalProcDed[MAX_MNODE];
 
  double TotalProcUtl[MAX_MNODE];
 
  mnode_t *N;

  const char *FName = "MClusterUpdateNodeState";
 
  DBG(3,fSTAT) DPrint("%s()\n",
    FName);
 
  memset(TotalTaskDed,0,sizeof(TotalTaskDed));
  memset(TotalProcDed,0,sizeof(TotalProcDed)); 
  memset(TotalProcUtl,0,sizeof(TotalProcUtl));
 
  /* add procs of all active jobs (newly updated or not) */
 
  for (J = MJob[0]->Next;(J != NULL) && (J != MJob[0]);J = J->Next)
    {
    if (MJOBISACTIVE(J))
      {
      for (rqindex = 0;J->Req[rqindex] != NULL;rqindex++)
        {
        RQ = J->Req[rqindex];
 
        for (nindex = 0;RQ->NodeList[nindex].N != NULL;nindex++)
          {
          N = RQ->NodeList[nindex].N;
 
          TotalTaskDed[N->Index] += RQ->NodeList[nindex].TC;
          TotalProcDed[N->Index] += RQ->NodeList[nindex].TC * (RQ->DRes.Procs >= 0) ?
                                      RQ->DRes.Procs : N->CRes.Procs;
          TotalProcUtl[N->Index] += RQ->NodeList[nindex].TC *
                                      RQ->URes.Procs / 100.0;
          } /* END for (nindex)   */
        }   /* END for (rqindex)  */
      }     /* END if (J->State)  */
    }       /* END for (J = MJob[0]->Next;(J != NULL) && (J != MJob[0]);J = J->Next) */
 
  for (nindex = 0;nindex < MAX_MNODE;nindex++)
    {
    N = MNode[nindex];
 
    if ((N == NULL) || (N->Name[0] == '\0'))
      break;
 
    if (N->Name[0] == '\1')
      continue;
 
    /* reset job info */
 
    N->JList[0] = NULL; 
 
    MNodeAdjustAvailResources(
      N,
      TotalProcUtl[N->Index],
      TotalProcDed[N->Index],
      TotalTaskDed[N->Index]);
 
    DBG(6,fPBS) DPrint("INFO:     node '%s' C/A/D procs:  %d/%d/%d\n",
      N->Name,
      N->CRes.Procs,
      N->ARes.Procs,
      N->DRes.Procs);
    }    /* END for (nindex) */
 
  /* associate job to node */
 
  for (J = MJob[0]->Next;(J != NULL) && (J != MJob[0]);J = J->Next)
    {
    if (MJOBISACTIVE(J))
      {
      MJobAddToNL(J,NULL);
      }
    }  /* END for (J) */
 
  return(SUCCESS);
  } /* END MClusterUpdateNodeState() */




int MClusterClearUsage()

  {
  int      nindex;
  mnode_t *N;

  const char *FName = "MClusterClearUsage";
 
  DBG(3,fSTRUCT) DPrint("%s()\n",
    FName);

  for (nindex = 0;nindex < MAX_MNODE;nindex++)
    {
    N = MNode[nindex];
 
    if ((N == NULL) || (N->Name[0] == '\0'))
      break;
 
    if (N->Name[0] == '\1')
      continue;
 
    memset(&N->DRes,0,sizeof(N->DRes));
    }  /* END for (nindex) */

  /* adjust global node */

  if (MSched.GN != NULL)
    {
    N = MSched.GN;

    /* reset global node */

    N->MTime = MSched.Time;
    N->ATime = MSched.Time;

    memcpy(&N->ARes,&N->CRes,sizeof(N->ARes));

    MNodeSetState(N,mnsIdle,0);
    }  /* END if (MNodeFind(MDEF_GNNAME,&N) == SUCCESS) */
 
  return(SUCCESS);
  }  /* END MClusterClearUsage() */




int MClusterShowARes(

  char *ResDesc,      /* I */
  int   DFlags,       /* I */
  int   DisplayMode,  /* I */
  char *Buf,          /* O */
  int   BufSize)      /* O */

  {
  char  UName[MAX_MNAME];
  char  GName[MAX_MNAME];
  char  AName[MAX_MNAME];
  char  CName[MAX_MNAME];
  char  QName[MAX_MNAME];
  char  PName[MAX_MNAME];

  char FeatureString[MAX_MLINE];

  long       MinTime;
  int        MinNodes;
  int        MinProcs;

  int        ReqMem;
  char       ReqMemCmp[MAX_MNAME];

  int        ShowSMP; /* (boolean) */

  int        Flags;   /* (BM) */

  char *BPtr;
  int   BSpace;

  const char *FName = "MClusterShowARes";

  DBG(2,fUI) DPrint("%s(%s,%d,%d,Buf,BufSize)\n",
    FName,
    (ResDesc != NULL) ? ResDesc : "NULL",
    DFlags,
    DisplayMode);

  if ((ResDesc == NULL) || (Buf == NULL))
    {
    return(FAILURE);
    }

  BPtr   = Buf;
  BSpace = BufSize;

  BPtr[0] = '\0';

  /* initialize response */

  if (DisplayMode == mwpXML)
    {
    /* NYI */
    }

  /* parse resource description */

  if (MUSScanF(ResDesc,"%x%s %x%s %x%s %x%s %ld %ld %ld %d %d %x%s %d %d %x%s %x%s %x%s",
       sizeof(UName),
       UName,
       sizeof(GName),
       GName,
       sizeof(AName),
       AName,
       sizeof(PName),
       PName,
       &MinTime,
       &MinNodes,
       &MinProcs,
       &ReqMem,
       &ReqMem,
       sizeof(ReqMemCmp),
       ReqMemCmp,
       &ShowSMP,
       &Flags,
       sizeof(CName),
       CName,
       sizeof(FeatureString),
       FeatureString,
       sizeof(QName),
       QName) == FAILURE)
    {
    /* invalid request string */

    DBG(3,fUI) DPrint("INFO:     cannot parse request\n");

    switch (DisplayMode)
      {
      case mwpXML:

        /* NYI */

        break;

      default:

        sprintf(BPtr,"ERROR:    cannot parse request\n");

        break;
      }  /* END switch(DisplayMode) */

    return(FAILURE);
    }

  /* NYI */

  return(SUCCESS);
  }  /* END MClusterShowARes() */



/* END MCluster.c */

