#!/usr/bin/env python
#
# This file is part of SALI
#
# SALI is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# SALI is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SALI.  If not, see <http://www.gnu.org/licenses/>.
#
# Copyright 2010-2013 SURFsara

from distutils.core import setup

setup(
        name = 'SALI',
        version = '1.6.10',

        description = 'sali server and utilities',
        long_description = 'sali server and utilities',
        author = 'Dennis Stam',
        author_email = 'sali@surfsara.nl',
        url = 'https://oss.trac.surfsara.nl/sali',
        license = 'GPL',
        
        classifiers = [
                'Development Status :: 1 Planning',
                'Environment :: Console',
                'Intended Audience :: System Administrators',
                'License :: OSI Approved :: GNU General Public License (GPL)',
                'Natural Language :: English',
                'Operating System :: Unix',
                'Programming Language :: Python',
                'Topic :: System :: System Administration',
        ],

        packages = ['sali','sali.server','SaliBitTornado','SaliBitTornado.BT1'],
        scripts = ['scripts/sali','scripts/sali_server'],
        data_files = [ 
        (   '/etc/sali', [ 
                'config/sali.cfg', 
                'config/getimage.exclude',
            ] ),
        (   '/etc/sali/rsync_stubs', [
                'config/rsync_stubs/00header.conf',
            ] )
        ],
)
