<?php
#
# Parses the ganglia XML tree and pulls out the pbs metrics.
# Assumes we have a $GHOME variable that points to ganglia, 
# usually "../..".
#
# Changed by: Bas van der Vlies <basv@sara.nl>
# Date      : 22 May 2003
# Desc.     : Made it cluster aware and make it work for our environment
#             Uses the pbs_stat.py module which publishes PBS data
#             Look for The HvB tags what is changed.
#
# SVN INFO:
#  $Id: get-openpbs-data.php 248 2003-09-26 06:24:37Z bas $


# HvB: PHP directive register_globals being off or on.
#      Just use the extract function.
#
if (!empty($_GET))
{
	extract($_GET);
}

# A 3-key array: "Cluster" / "PBS job id" / "Attribute name" = Attribute value;
$pbs_jobs;

# A 1-key array: "Key" = Value. Holds global queue state.
$pbs_QueueState;


# A cluster name.
$pbs_clustername;


function get_openpbs_data()
{
	global $PBS_CLUSTERS, $HTTP_GET_VARS;

	# Variables that hold the job and queue status
	#
	global $pbs_jobs, $pbs_QueueState;

	#echo "bas $pbs_clustername<br>";
	#echo "<PRE>";
	#print_r($PBS_CLUSTERS);
	#print_r($HTTP_GET_VARS);
	#echo "</PRE>";

	# Collect cluster name from the command line if it exists.
	if ($HTTP_GET_VARS["c"]) 
	{
      		$pbs_clustername = escapeshellcmd(rawurldecode($HTTP_GET_VARS["c"]));

		# HvB: Look if there is a connection table
		#
		#echo "bas $pbs_clustername<br>";
		if ($PBS_CLUSTERS[$pbs_clustername])
		{
			$ganglia_ip = $PBS_CLUSTERS[$pbs_clustername][0];
			$ganglia_port = $PBS_CLUSTERS[$pbs_clustername][1];
		}
		#echo "get-pbs.php $ganglia_ip $ganglia_port<br>";


		# Get data from gmetad if we are querying from a remote machine.
		$rc=parseGangliaXML($ganglia_ip, $ganglia_port);
	}
	else
	{
		# HvB debug
		#echo "Bas no cluster name $ganglia_ip<br>";

		# Try querying gmond if we are on the local machine - more responsive.S
		#
		$rc=parseGangliaXML($ganglia_ip, 8649);
	}

	if (!rc) 
	{
    		echo "<H1>Cannot connect to Ganglia source ($ganglia_ip:$ganglia_port)".
		"for ganglia PBS info.</H1>";
    		return;
	}

	# Give result back
	#
	#echo "<PRE>";
	#print_r($pbs_jobs);
	#echo "</PRE>";

	return array($pbs_clustername, $pbs_jobs, $pbs_QueueState);
}


#
# Expecting an XML stream from a gmond from the local
# cluster.
# Assumes that we have a cluster name in $pbs_clustername.
#
function startElement($parser, $name, $attrs)
{
	global $pbs_jobs, $pbs_QueueState, $pbs_clustername;

	# HvB some debug cmd's
	#echo "<PRE>";
	#echo "startElement";
	#print_r( $name );
	#echo "</PRE>";

	if ($name=="CLUSTER") {
		$pbs_clustername = $attrs[NAME];
		$pbs_QueueState[LOCALTIME] = $attrs[LOCALTIME];
	}
	else if ($name=="METRIC" and strstr($attrs[NAME],"pbs-job")) {

		# HvB debug
		# echo "<PRE>";
		# print_r( $attrs );
		# echo "</PRE>";

		if ($attrs[TN])
			{
				# Ignore dead metrics. Detect and mask failures.
				if ($attrs[TN] > $attrs[TMAX] * 4)
					return;
			}

		$jobid=0;
		sscanf($attrs[NAME], "pbs-job-%d", $jobid);

		# echo "Adding job $jobid<br>";
	
		# Note explode is faster than split.
		$fields = explode(" ", $attrs[VAL]);

		foreach ($fields as $f) {
			$l=explode("=",$f);
			$key = $l[0];

			# HvB debug
			#echo "<PRE>";
			#print_r( $l );
			#echo "key = $key";
			#echo "</PRE>";

			$pbs_jobs[$pbs_clustername][$jobid][$key] = $l[1];
		}
		$pbs_jobs[$pbs_clustername][$jobid][id] = $jobid;

		# HvB debug
		#echo "<PRE>";
		#print_r( $pbs_jobs );
		#echo "</PRE>";

	}
	else if ($name=="METRIC" and strstr($attrs[NAME],"pbs-state")) 
	{
		#echo "<PRE>";
		#print_r($attrs);
		#echo "</PRE>";

        	$fields = explode(",", $attrs[VAL]);
        	foreach ($fields as $f) 
		{
            		$l=explode("=",$f);
            		$key = $l[0];
            		$pbs_QueueState[$key]=$l[1];
        	}
	}
}

function endElement($parser, $name)
{
}

#
# A PBS-specific XML parser. Expects to find
# a ganglia gmond on the local host. If we cannot contact a gmond
# on the localhost, any other gmond in the cluster should do. (The
# advantage of using ganglia)
#
function parseGangliaXML($ip, $port)
{
   $timeout = 3.0;
   $errstr = "";
   $errno  = ""; 

   # HvB: get the current time. So we can calculate how long a job is running
   # or in the queue
   #
   $pbs_QueueState[LOCALTIME] = time();
   #echo "LOCALTIME $pbs_QueueState[LOCALTIME] <br>";
         
   $parser = xml_parser_create();
   xml_set_element_handler($parser, "startElement", "endElement");

   $fp = fsockopen($ip, $port, &$errno, &$errstr, $timeout);
   if (!$fp) {
      $error = "fsockopen error: $errstr";
      # HvB debug
      # echo "Bas error: $errstr<br>";
      return FALSE;
   }

   while(!feof($fp)) {
         $data = fread($fp, 16384);
         if (!xml_parse($parser, $data, feof($fp))) {
               $error = sprintf("XML error: %s at %d",
                  xml_error_string(xml_get_error_code($parser)),
                  xml_get_current_line_number($parser));
               fclose($fp);
               return FALSE;
         }
   }
   fclose($fp);

   return TRUE;
}

?>
