<?php
#
# Some helpful functions common to two or more php scripts in this
# directory.
#
# SVN INFO:
#  $Id: functions.php 245 2003-09-25 14:10:28Z bas $


# Decodes bas-style encoded name lists as:
#	e:4,7,9
#	comp:4,5;sec:6,7,8
#
# HvB added a extra argument to the decode function.
# And return a new namelist
#
function decode_sara($nodes, $domain)
{
   #echo "decode<br>";
   #print_r( $nodes );

   $basenamelist = explode(";", $nodes);
   foreach ($basenamelist as $line)
   {
   	list($basename, $extlist) = split(":", $line);
	$extlist = explode(",", $extlist);

	$new_namelist = array();
	foreach ($extlist as $ext)
	{
   		$new_namelist[] = $basename . $ext . ".$domain";
	}
	return $new_namelist;
		
   }
}

# Turns a time interval (in seconds) into a "2days 3:15:49" string, like the
# uptime command.
function nicetime($uptimeS)
{
   if (!$uptimeS) return "";

   $uptimeD=intval($uptimeS/86400);
   $uptimeS=$uptimeD ? $uptimeS % ($uptimeD*86400) : $uptimeS;
   $uptimeH=intval($uptimeS/3600);
   $uptimeS=$uptimeH ? $uptimeS % ($uptimeH*3600) : $uptimeS;
   $uptimeM=intval($uptimeS/60);
   $uptimeS=$uptimeM ? $uptimeS % ($uptimeM*60) : $uptimeS;

   $s = ($uptimeD!=1) ? "s" : "";
   if ($uptimeD>0)
     return "$uptimeD day$s, $uptimeH:$uptimeM:$uptimeS";
   else
     return "$uptimeH:$uptimeM:$uptimeS";
}

?>
