<?php
#
# A Page that shows the job placements or assignments in the
# cluster. Similar to the physical view ganglia page. Inspired
# by ideas from Dave Pierce at Scripps Institute of Oceanography.
#
# Uses the pbs_stat.py which publishes PBS data using Ganglia's gmetric. 
# Ganglia parsing code based on work by Matt Massie <massie@cs.berkeley.edu>.
#
# Requires ganglia >= 2.5.1 with garbage collecting.
#
# SVN Info:
#	$Id: assignments.php 369 2004-03-18 15:01:33Z bas $
#
$GHOME="../..";
include_once "$GHOME/class.TemplatePower.inc.php";
include_once "$GHOME/conf.php";

include_once "./get-ganglia.php";
include_once "./get-openpbs-data.php";

include_once "$GHOME/functions.php";
include_once "./functions.php";

# get opebpbs data 
#
list($clustername, $jobs, $QueueState) = get_openpbs_data();
$jobs = $jobs[$clustername];


$tpl = new TemplatePower("templates/assignments.tpl");
$tpl->assignInclude("header", "templates/header.tpl");
$tpl->prepare();

$cluster_url = rawurlencode($clustername);

$self="./assignments.php";
$tpl->assign("self",$self);
$tpl->assign("title", "Parallel Job Assignments");
$tpl->assign("link", "<a href=./queue.php?c=$cluster_url>Back to Job Queue</a>");
$tpl->assign("cluster_url", $cluster_url);
$tpl->assign("cluster",$clustername);
$tpl->assign("now",date("r"));


#
# Make suitable assignments data structures.
#
$assignments = array();
$jobnodes = array();
$nodeusers = array();

if (is_array($jobs)) 
{
	foreach ($jobs as $id=>$job)
	{
		if (!$job[nodes]) continue;

		$nodelist = decode_sara($job[nodes], $job[domain]);
		foreach ($nodelist as $name) 
		{
			# Track usage by node name.
			$assignments[$name][jobs][$id] += 1;
			$assignments[$name][P] += 1;
			# To count how many unique nodes this job runs on.
			$jobnodes[$id][$name] = 1;
			# To count how many nodes are used by whom (which user).
			$nodeusers[$job[user]][$name] = 1;
		}
	}
}

#-------------------------------------------------------------------------------
# Displays a rack and all its nodes.
function showrack($ID)
{
	global $racks, $clustername, $tpl, $assignments; 
	global $onejob, $oneuser, $jobnodes, $nodeusers;

	global $jobs;

	if ($ID>=0) {
		$tpl->assign("RackID","<tr><th>Rack $ID</th></tr>");
	}

	# A string of node HTML for the template.
	$nodes="";

	foreach ($racks[$ID] as $name) {

		if ($onejob and !$jobnodes[$onejob][$name]) 
			continue;
		if ($oneuser and !$nodeusers[$oneuser][$name]) 
			continue;

		$P = $assignments[$name][P];
		$jobsizes = $assignments[$name][jobs];

		if (!count($jobsizes)) 
			$jobrow = "";
		else 
		{
			$class = $P ? "job" : "";
			$jobrow = "<tr><td colspan=2 class=$class>";
			#
			# Show who is using what processors on this node.
			#
			foreach ($jobsizes as $id=>$P) {
				if (!$id) continue;
				$job = $jobs[$id];
				$jobrow .= "$P: $job[user] <a href=\"./job.php?id=$id&c=$clustername\">$id</a> ";
			}
			$jobrow .= "</td></tr>";
		}
	
		# Use the standard ganglia node box function.
		$nodes .= nodebox($name, 1, "<i>$name</i>", $jobrow);
	}

	return $nodes;
}

#
# My Main
#

# 2Key = "Rack ID / Rank (order in rack)" = [hostname, UP|DOWN]
$racks = physical_racks();

# Make a $cols-wide table of Racks.
$cols=5;
$i=1;
foreach ($racks as $rack=>$v) 
{
	$tpl->newBlock("racks");

	$racknodes = showrack($rack);

	$tpl->assign("nodes",$racknodes);

	if (! ($i++ % $cols))
		$tpl->assign("tr","</tr><tr>");
}

#
# Summarize the jobs on the cluser.
#
if (is_array($jobs)) {
	foreach ($jobs as $id=>$job) 
	{
		if ($job[state] != "R") continue;
		$tpl->newBlock("jobs");
		$checked = ($onejob==$id) ? $checked="checked" : "";
		$tpl->assign("button",
		 "<input type=radio name=onejob value=$id OnClick=\"selectjob.submit()\" $checked>");
		$n = count($jobnodes[$id]);
		$s = $n>1 ? "s" : "";
		$Ps = $job[P]>1 ? "s" : "";
		$tpl->assign("summary",
			"<a href=\"./job.php?id=$id&c=$clustername\">($id)</a> ".
			"$job[user]/$job[name], ".
			"$job[P] proc$Ps on $n node$s. ");
	}
	foreach ($nodeusers as $user=>$nodes) 
	{
		$tpl->newBlock("users");
		$checked = ($oneuser==$user) ? "checked" : "";
		$tpl->assign("button",
		 "<input type=radio name=oneuser value=\"$user\" OnClick=\"selectuser.submit()\" $checked>");
		$tpl->assign("user","$user (".count($nodes)." nodes)");
	}
}

$tpl->printToScreen();

?>
