<?php
#
# A Page to monitor the PBS parallel job scheduling queues.
# using Ganglia's gmetric. Ganglia parsing code based on work
# by Matt Massie <massie@cs.berkeley.edu>.
#
# Requires ganglia >= 2.5.1 with garbage collecting.
#
# Changed by: Bas van der Vlies <basv@sara.nl>
# Date      : 22 May 2003
# Desc.     : Made it cluster aware and make it work for our environment
#             Uses the pbs_stat.py module which publishes PBS data
#             Look for The HvB tags what is changed.
#
# SVN INFO:
#  $Id: queue.php 571 2004-07-14 08:37:51Z bas $

# HvB: PHP directive register_globals being off or on.
#      Just use the extract function.
#
if (!empty($_GET)) 
{
	extract($_GET);
}

$GHOME="../..";
include_once "$GHOME/class.TemplatePower.inc.php";
include_once "./get-pbs.php";
include_once "./functions.php";

# HvB
#
$clusterURL = rawurlencode($cluster);

# The number of active nodes, according to PBS/TORQUE.
#
$activeP=0;
$activeJobs=0;

$tpl = new TemplatePower("templates/queue.tpl");
$tpl->assignInclude("header", "templates/header.tpl");
$tpl->prepare();

$self="./queue.php";
$tpl->assign("self",$self);
$tpl->assign("title", "Parallel Job Queue");

# HvB Added clusterURL
#
$tpl->assign("link", 
   "<a href=./assignments.php?c=$clusterURL>Physical Job Assignments</a>");

if (!$sortby) $sortby="id";
if (!$sortorder) $sortorder="up";
$tpl->assign("sortby",$sortby);
$tpl->assign("sortorder",$sortorder);
$tpl->assign("sortvars","sortby=$sortby&sortorder=$sortorder");

# HvB
#
$tpl->assign("clusterURL", $clusterURL);

$tpl->assign("cluster",$cluster);
$tpl->assign("user",$user);
$tpl->assign("now",date("r"));

#
# Some templatePower tricks to set the sortby links.
#
$columns=array("id","user","processors","state","name","runtime","queue");
foreach ($columns as $c) {
	$name=ucfirst($c);
	if ($sortby==$c) 
	{
		$tpl->assign("${c}SortLink",$name);
	}
	else 
	{
		$tpl->assign("${c}SortLink",
		  "<a href=$self?c=$clusterURL&sortby=$c&sortorder=$sortorder>$name</a>");
	}
}

$orders=array("up","down");
foreach ($orders as $o) {
	$name=ucfirst($o);
	if ($sortorder==$o) 
		$tpl->assign("${o}SortOrder",$name);
	else
		# HvB added clusterURL
		#
		$tpl->assign("${o}SortOrder",
			"<a href=$self?c=$clusterURL&sortby=$sortby&sortorder=$o>$name</a>");
}

function cmp($a,$b)
{
	global $sortby, $sortorder;

	# HvB: there is no processor or runtime array field
	# use for processors : P and for runtime : mtime
	#
	if ( $sortby == "processors" )
		$sortby = "P";
	else if ( $sortby == "runtime" )
		$sortby = "mtime";

	if ($a[$sortby] == $b[$sortby]) return 0;
	if ($sortorder=="up") 
		return ($a[$sortby] > $b[$sortby]) ? 1 : -1;
	else
		return ($a[$sortby] < $b[$sortby]) ? 1 : -1;
}


function display_job($job_info, $localtime)
{
	global $tpl;
	global $clusterURL;
	global $activeP;
	global $activeJobs;

	$tpl->newBlock("job");
	$tpl->assign("color",rowStyle());
	$tpl->assign("id",$job_info[id]);
	$tpl->assign("user",$job_info[user]);
	$tpl->assign("processors",$job_info[P]);
	$tpl->assign("state",$job_info[state]);
	$tpl->assign("name",$job_info[name]);
	$tpl->assign("queue",$job_info[queue]);

	# HvB added clusterURL
	#
	$tpl->assign("cluster",$clusterURL);

	// HvB we have te right mtime
	$mtime = $job_info[mtime];
	// echo "Job $id has mtime of $mtime sec ($D, $m, $d, $t, $y)<br>";
	$timeInState = nicetime($localtime - $mtime);

	if ($job_info[state] == "R") 
		{
			$activeP += $job_info[P];
			$activeJobs++;
			$tpl->assign("runtime",$timeInState);
		}
	else if ($job_info[state] == "Q")
		{
			$tpl->assign("runtime","<small>$timeInState</small>");
		}
}

#
# Display the set of PBS jobs in the queue.
#
if (is_array($jobs[$clustername])) {
	uasort($jobs[$clustername], "cmp");
	foreach ($jobs[$clustername] as $id=>$job) {
		if ($user)
			{
			if ($user == $job[user])
				{
				  display_job($job, $QueueState[LOCALTIME]);
				}
					
			}
		else
			{
				display_job($job, $QueueState[LOCALTIME]);
			}

	}
}


# The total number of processors, according to the Queuing system.
$totalP = $QueueState[P];
if ($activeP > $totalP) $activeP = $totalP;

if ($totalP)
	{
		# We lie about this to mask the case when gmond hasn't yet
		# deleted the gmetric of a finished job.
		if ($activeP > $totalP) $activeP = $totalP;

		$percentUsed = sprintf("%.2f",($activeP/$totalP)*100);
	}
else
	$percentUsed = "0.00";

$s = ($activeJobs!=1) ? "s" : "";
$summary = "$activeJobs Active Job$s. ".
	"$activeP of $totalP Processors Active ($percentUsed%)";

# See FAQ:1 on the template power site for why we need "_ROOT".
$tpl->assign("_ROOT.summary",$summary);

$tpl->printToScreen();
?>
 
