<?php
#
# Parses the ganglia XML tree and pulls out the pbs metrics.
# Assumes we have a $GHOME variable that points to ganglia, 
# usually "../..".
#
# Changed by: Bas van der Vlies <basv@sara.nl>
# Date      : 22 May 2003
# Desc.     : Made it cluster aware and make it work for our environment
#             Uses the pbs_stat.py module which publishes PBS data
#             Look for The HvB tags what is changed.
#
# SVN INFO:
#  $Id: get-pbs.php 97 2003-06-06 06:51:27Z bas $

include_once "$GHOME/conf.php";
include_once "ganglia-pbs.php";

# HvB: PHP directive register_globals being off or on.
#      Just use the extract function.
#
if (!empty($_GET))
{
	extract($_GET);
}



# Collect cluster name from the command line if it exists.
if ($HTTP_GET_VARS["c"]) 
	{
      $cluster = escapeshellcmd(rawurldecode($HTTP_GET_VARS["c"]));

      # HvB: Look if there is a connection table
      #
      # echo "$cluster<br>";
      if ($PBS_CLUSTERS[$cluster])
      {
        $ganglia_ip = $PBS_CLUSTERS[$cluster][0];
	$ganglia_port = $PBS_CLUSTERS[$cluster][1];
      }
      # echo "get-pbs.php $ganglia_ip<br>";


      # Get data from gmetad if we are querying from a remote machine.
      $rc=parseGangliaXML($ganglia_ip, $ganglia_port);
   }
else
   {
      # HvB debug
      # echo "Bas no cluster name $ganglia_ip<br>";

      # Try querying gmond if we are on the local machine - more responsive.S
      #
      $rc=parseGangliaXML($ganglia_ip, 8649);
   }

if (!rc) {
    echo "<H1>Cannot connect to Ganglia source ($ganglia_ip:$ganglia_port)".
	"for ganglia PBS info.</H1>";
    return;
}

# We should have a cluster specified from ganglia-pbs.. 

?>
