<?php
#
# Parses the XML from a ganlia monitor daemon. For use with
# the rocks PBS monitor pages.
# 
# @Copyright@
# 
# 				Rocks
# 		     http://www.rocksclusters.org
# 			     Version 2.3.1
# 
# Copyright (c) 2003 The Regents of the University of California. All
# rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
# 
# 3. All advertising materials mentioning features or use of this
# software must display the following acknowledgement: This product
# includes software developed by the ROCKS CLUSTER GROUP at the San
# Diego Supercomputer Center and its contributors.
# 
# 4. Neither the name of the Center nor the names of its contributors
# may be used to endorse or promote products derived from this software
# without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
# IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# @Copyright@

# Changed by: Bas van der Vlies <basv@sara.nl>
# Date      : 22 May 2003
# Desc.     : Made it cluster aware and make it work for our environment
#             Uses the pbs_stat.py module which publishes PBS data
#             Look for The HvB tags what is changed.
#
# SVN INFO:
#  $Id: ganglia-pbs.php 97 2003-06-06 06:51:27Z bas $

# HvB: PHP directive register_globals being off or on.
#      Just use the extract function.
#
if (!empty($_GET))
{
	extract($_GET);
}


# A 3-key array: "Cluster" / "PBS job id" / "Attribute name" = Attribute value;
$jobs;

# A 1-key array: "Key" = Value. Holds global queue state.
$QueueState;

# A cluster name.
$cluster;

#
# Expecting an XML stream from a gmond from the local
# cluster.
# Assumes that we have a cluster name in $cluster.
#
function startElement($parser, $name, $attrs)
{
	global $jobs, $cluster, $QueueState;

	# HvB some debug cmd's
	# print_r( $name );


	if ($name=="CLUSTER") {
		$cluster = $attrs[NAME];
		$QueueState[LOCALTIME] = $attrs[LOCALTIME];
	}
	else if ($name=="METRIC" and strstr($attrs[NAME],"pbs-job")) {

		# HvB debug
		# echo "<PRE>";
		# print_r( $attrs );
		# echo "</PRE>";

		if ($attrs[TN])
			{
				# Ignore dead metrics. Detect and mask failures.
				if ($attrs[TN] > $attrs[TMAX] * 4)
					return;
			}

		$jobid=0;
		sscanf($attrs[NAME], "pbs-job-%d", $jobid);

		# echo "Adding job $jobid<br>";
	
		# Note explode is faster than split.
		$fields = explode(" ", $attrs[VAL]);

		foreach ($fields as $f) {
			$l=explode("=",$f);
			$key = $l[0];

			# HvB debug
			#echo "<PRE>";
			#print_r( $l );
			#echo "key = $key";
			#echo "</PRE>";

			$jobs[$cluster][$jobid][$key] = $l[1];
		}
		$jobs[$cluster][$jobid][id] = $jobid;

		# HvB debug
		#echo "<PRE>";
		#print_r( $jobs );
		#echo "</PRE>";

	}
	else if ($name=="METRIC" and strstr($attrs[NAME],"pbs-state")) {
        $fields = explode(",", $attrs[VAL]);
        foreach ($fields as $f) {
            $l=explode("=",$f);
            $key = $l[0];
            $QueueState[$key]=$l[1];
        }
	}
}

function endElement($parser, $name)
{
}

#
# A PBS-specific XML parser. Expects to find
# a ganglia gmond on the local host. If we cannot contact a gmond
# on the localhost, any other gmond in the cluster should do. (The
# advantage of using ganglia)
#
function parseGangliaXML()
{
   # Parameters are optional
   # Defaults...
   $ip = "127.0.0.1";
   $port = 8651;
   $timeout = 3.0;
   $errstr = "";
   $errno  = ""; 

   # HvB: get the current time. So we can calculate how long a job is running
   # or in the queue
   #
   $QueueState[LOCALTIME] = time();
   #echo "LOCALTIME $QueueState[LOCALTIME] <br>";
         
   switch( func_num_args() ) {        
         case 2:
            $port = func_get_arg(1);
         case 1:
            $ip   = func_get_arg(0);
   }
   # HvB debug
   # echo "Bas parseGangliaXML $ip: $port<br>";

   $parser = xml_parser_create();
   xml_set_element_handler($parser, "startElement", "endElement");

   $fp = fsockopen($ip, $port, &$errno, &$errstr, $timeout);
   if (!$fp) {
      $error = "fsockopen error: $errstr";
      # HvB debug
      # echo "Bas error: $errstr<br>";
      return FALSE;
   }

   while(!feof($fp)) {
         $data = fread($fp, 16384);
         if (!xml_parse($parser, $data, feof($fp))) {
               $error = sprintf("XML error: %s at %d",
                  xml_error_string(xml_get_error_code($parser)),
                  xml_get_current_line_number($parser));
               fclose($fp);
               return FALSE;
         }
   }
   fclose($fp);

   return TRUE;
}

?>
