<?php
#
# A Page that shows the job placements or assignments in the
# cluster. Similar to the physical view ganglia page. Inspired
# by ideas from Dave Pierce at Scripps Institute of Oceanography.
#
# using Ganglia's gmetric. 
# Ganglia parsing code based on work by Matt Massie <massie@cs.berkeley.edu>.
#
# Requires ganglia >= 2.5.1 with garbage collecting.
#
# Changed by: Bas van der Vlies <basv@sara.nl>
# Date      : 22 May 2003
# Desc.     : Made it cluster aware and make it work for our environment
#             Uses the pbs_stat.py module which publishes PBS data
#             Look for The HvB tags what is changed.
#
# SVN INFO:
#  $Id: assignments.php 97 2003-06-06 06:51:27Z bas $

# HvB: PHP directive register_globals being off or on.
#      Just use the extract function.
#
if (!empty($_GET))
{
	extract($_GET);
}


$GHOME="../..";
include_once "$GHOME/class.TemplatePower.inc.php";
include_once "$GHOME/functions.php";
include_once "./get-pbs.php";
include_once "./get-ganglia.php";
include_once "./functions.php";

# HvB
#
$clusterURL = rawurlencode($cluster);
#echo "$clusterURL<br>";


$tpl = new TemplatePower("templates/assignments.tpl");
$tpl->assignInclude("header", "templates/header.tpl");
$tpl->prepare();


$self="./assignments.php";
$tpl->assign("self",$self);
$tpl->assign("title", "Parallel Job Assignments");
$tpl->assign("link", "<a href=./queue.php?c=$clusterURL>Back to Job Queue</a>");

# HvB
#
$tpl->assign("clusterURL", $clusterURL);

$tpl->assign("cluster",$cluster);
$tpl->assign("now",date("r"));

#
# Make suitable assignments data structures.
#
$assignments = array();
$jobnodes = array();
$nodeusers = array();

if (is_array($jobs[$cluster])) {
	foreach ($jobs[$cluster] as $id=>$job) {
		if (!$job[nodes]) continue;

		# HvB extra argument to decode function
		#
		$nodelist = decode($job[nodes], $job["domain"]);

		foreach ($nodelist as $name) {
			# Track usage by node name.
			$assignments[$name][jobs][$id] += 1;
			$assignments[$name][P] += 1;
			# To count how many unique nodes this job runs on.
			$jobnodes[$id][$name] = 1;
			# To count how many nodes are used by whom (which user).
			$nodeusers[$job[user]][$name] = 1;
		}
	}
}


#-------------------------------------------------------------------------------
#
# Function to print out a node box with its hardware and load
# like physical_view.php in ganglia-webfrontend core.
#
function nodebox($cluster, $name, $P, $nodejobs)
{
	global $metrics, $hosts, $jobs, $GHOME, $onejob;

        # HvB
	#
	global $clusterURL;

	if (!$nodejobs) $nodejobs=array("");
	$load_scalar=0.2;
	$node = "";
	#echo "Cluster is $cluster, host name is $name<br>";

	$M=$metrics[$cluster];
	$mem_totalMB = intval(intval($M[mem_total][$name][VAL])/1024);
	$load_one=$M[load_one][$name][VAL];
	$cpu_speed=$M[cpu_speed][$name][VAL];
   
	# Choose load color. 
	$cpu_num=$M[cpu_num][$name][VAL]; 
	if (!$cpu_num) { $cpu_num=1; }
	$loadindex=intval($load_one/($load_scalar*$cpu_num))+1;
	# 10 is currently the highest allowed load index.
	$load= $loadindex > 10 ? "L10" : "L$loadindex";
 
	$rowclass = ($hosts[$cluster][$name]) ? rowStyle() : "down";

	$hosturl=rawurlencode($name);

	# HvB added clusterURL
	#
	$node .= "<tr><td class=$rowclass>".
	   "<table width=100% cellpadding=1 cellspacing=0 border=0><tr>".
	   "<td><a href=\"$GHOME/?p=2&c=$clusterURL&h=$hosturl\">".
	   "<font size=-1>$name</font></a>".
	   "&nbsp;<br>\n";

	$hardware = "<i>$cpu_num x</i> $cpu_speed<em>Mhz</em>, $mem_totalMB<em>MB</em>";

	#
	# Load box.
	#
	$node .= "</td><td align=right valign=top>".
	   "<table cellspacing=1 cellpadding=3 border=0><tr>".
	   "<td class=$load align=right><small>$load_one</small>".
	   "</td></tr></table>";
	$class = $P ? "job" : "";
	$node .= "<tr><td colspan=2 class=$class>";
	#
	# Show who is using how many processors on this node.
	#
	foreach ($nodejobs as $id=>$P) {
		if (!$id) continue;
		$job = $jobs[$cluster][$id];

		# HvB added clusterURL
		#
		$node .= "$P: $job[user] <a href=\"./job.php?c=$clusterURL&id=$id\">$id</a> ";
	}
	$node .= "</td></tr>";
	$node .= "<tr><td colspan=2><font size=-2>$hardware</font></td></tr>";
	$node .= "</table>\n";
	$node .= "</td></tr>\n";
	return $node;
}

#-------------------------------------------------------------------------------
# Displays a rack and all its nodes.
function showrack($ID)
{
   global $racks, $cluster, $tpl, $assignments; 
   global $onejob, $oneuser, $jobnodes, $nodeusers;

   if ($ID>=0) {
      $tpl->assign("RackID","<tr><th>Rack $ID</th></tr>");
   }

   # A string of node HTML for the template.
   $nodes="";

   foreach ($racks[$ID] as $node) {
      $name=$node[0];

	  if ($onejob and !$jobnodes[$onejob][$name]) continue;
	  if ($oneuser and !$nodeusers[$oneuser][$name]) continue;

	  $nodes .= nodebox($cluster, $name, 
	  	$assignments[$name][P], 
		$assignments[$name][jobs]);

      $tpl->assign("nodes",$nodes);
   }
}

#
# My Main
#

# 2Key = "Rack ID / Rank (order in rack)" = [hostname, UP|DOWN]
$racks;

#
# Make racks data structure. We try to order the nodes by their physical
# location in the cluster.
#
# If we don't know a node's location, it goes in a negative ID rack.
#
$i=1;
$unknownID=-1;
if (is_array($hosts[$cluster])) {
   foreach ($hosts[$cluster] as $host=>$v) {
      #
      # Try to find the node's location in the cluster.
      list($rack, $rank) = findlocation($v);

      if ($rack>=0 and $rank>=0) {
         $racks[$rack][$rank]=array($v[NAME],"UP");
         continue;
      }
      else {
         $i++;
         if (! ($i % 25)) {
            $unknownID--;
         }
         $racks[$unknownID][] = array($v[NAME],"UP");
      }
   }
}
if (is_array($hosts_down[$cluster])) {
   foreach ($hosts_down[$cluster] as $host=>$v) {
      list($rack, $rank) = findlocation($v);
      if ($rack>=0 and $rank>=0) {
         $racks[$rack][$rank]=array($v[NAME],"DOWN");
         continue;
      }
      else {
         $i++;
         if (! ($i % 25)) {
            $unknownID--;
         }
         $racks[$unknownID][] = array($v[NAME],"DOWN");
      }
   }
}

if (!$racks) return;

# Sort the racks array.
if ($unknownID<-1) { krsort($racks); }
else {
   ksort($racks);
   reset($racks);
   while (list($rack,) = each($racks)) {
      # In our convention, y=0 is close to the floor.
      krsort($racks[$rack]);
   }
}

# Make a $cols-wide table of Racks.
$cols=5;
$i=1;
foreach ($racks as $rack=>$v) {
   $tpl->newBlock("racks");

   showrack($rack);

   if (! ($i++ % $cols)) {
      $tpl->assign("tr","</tr><tr>");
   }
}

#
# Summarize the jobs on the cluster.
#
if (is_array($jobs[$cluster])) {
	foreach ($jobs[$cluster] as $id=>$job) {
		if ($job[state] != "R") continue;
		$tpl->newBlock("jobs");
		$checked = ($onejob==$id) ? $checked="checked" : "";
		$tpl->assign("button",
		 "<input type=radio name=onejob value=$id OnClick=\"selectjob.submit()\" $checked>");
		$n = count($jobnodes[$id]);
		$s = $n>1 ? "s" : "";
		$Ps = $job[P]>1 ? "s" : "";

		# HvB added clusterURL
		#
		$tpl->assign("summary",
			"<a href=\"./job.php?c=$clusterURL&id=$id\">($id)</a> ".
			"$job[user]/$job[name], ".
			"$job[P] proc$Ps on $n node$s. ");
	}
	foreach ($nodeusers as $user=>$nodes) {
		$tpl->newBlock("users");
		$checked = ($oneuser==$user) ? "checked" : "";
		$tpl->assign("button",
		 "<input type=radio name=oneuser value=\"$user\" OnClick=\"selectuser.submit()\" $checked>");
		$tpl->assign("user","$user (".count($nodes)." nodes)");
	}
}

$tpl->printToScreen();

?>
